<?php
if (!defined('ABSPATH')) exit;

// Ayarları kaydet
if (isset($_POST['mimoza_save_settings']) && check_admin_referer('mimoza_settings_nonce')) {
    
    // API anahtarlarını kaydet
    update_option('mimoza_openai_api_key', sanitize_text_field($_POST['mimoza_openai_api_key']));
    update_option('mimoza_claude_api_key', sanitize_text_field($_POST['mimoza_claude_api_key']));
    update_option('mimoza_gemini_api_key', sanitize_text_field($_POST['mimoza_gemini_api_key']));
    update_option('mimoza_pexels_api_key', sanitize_text_field($_POST['mimoza_pexels_api_key']));
    update_option('mimoza_unsplash_api_key', sanitize_text_field($_POST['mimoza_unsplash_api_key']));
    update_option('mimoza_pixabay_api_key', sanitize_text_field($_POST['mimoza_pixabay_api_key']));
    
    echo '<div class="notice notice-success is-dismissible"><p><strong>✓ Ayarlar başarıyla kaydedildi!</strong></p></div>';
}
?>

<div class="wrap mimoza-settings">
    <h1>⚙️ Mimoza AI SEO - Ayarlar</h1>
    
    <!-- Info Box -->
    <div class="notice notice-info" style="background: #e7f3ff; border-left: 4px solid #2196F3;">
        <p>
            <strong>💡 İpucu:</strong> API anahtarlarını girdikten sonra mutlaka 
            <strong>"Ayarları Kaydet"</strong> butonuna tıklayın.
        </p>
    </div>
    
    <form method="post" action="">
        <?php wp_nonce_field('mimoza_settings_nonce'); ?>
        
        <div class="settings-container">
            
            <!-- AI API Ayarları -->
            <div class="settings-section">
                <h2>🤖 AI API Anahtarları</h2>
                <p class="description">
                    Makale üretmek için en az bir AI servisi API anahtarı gereklidir.
                </p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label>OpenAI (ChatGPT)</label>
                        </th>
                        <td>
                            <input type="password" 
                                   name="mimoza_openai_api_key" 
                                   value="<?php echo esc_attr(get_option('mimoza_openai_api_key')); ?>" 
                                   class="regular-text api-key-input" 
                                   placeholder="sk-..." />
                            <button type="button" class="button toggle-password">👁️</button>
                            <p class="description">
                                <a href="https://platform.openai.com/api-keys" target="_blank">
                                    API Anahtarı Al →
                                </a>
                                GPT-3.5 ve GPT-4 için gerekli
                            </p>
                            <?php if (get_option('mimoza_openai_api_key')): ?>
                                <span style="color: green;">✓ Kayıtlı</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Boş</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label>Claude (Anthropic)</label>
                        </th>
                        <td>
                            <input type="password" 
                                   name="mimoza_claude_api_key" 
                                   value="<?php echo esc_attr(get_option('mimoza_claude_api_key')); ?>" 
                                   class="regular-text api-key-input" 
                                   placeholder="sk-ant-..." />
                            <button type="button" class="button toggle-password">👁️</button>
                            <p class="description">
                                <a href="https://console.anthropic.com/" target="_blank">
                                    API Anahtarı Al →
                                </a>
                                Claude 3 modelleri için
                            </p>
                            <?php if (get_option('mimoza_claude_api_key')): ?>
                                <span style="color: green;">✓ Kayıtlı</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Boş</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label>Google Gemini (ÖNERİLEN)</label>
                        </th>
                        <td>
                            <input type="password" 
                                   name="mimoza_gemini_api_key" 
                                   value="<?php echo esc_attr(get_option('mimoza_gemini_api_key')); ?>" 
                                   class="regular-text api-key-input" 
                                   placeholder="AIza..." />
                            <button type="button" class="button toggle-password">👁️</button>
                            <p class="description">
                                <a href="https://makersuite.google.com/app/apikey" target="_blank">
                                    API Anahtarı Al →
                                </a>
                                <strong>✨ Ücretsiz kullanım kotası mevcut!</strong>
                            </p>
                            <?php if (get_option('mimoza_gemini_api_key')): ?>
                                <span style="color: green;">✓ Kayıtlı</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Boş</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Resim API Ayarları -->
            <div class="settings-section">
                <h2>🖼️ Resim API Anahtarları</h2>
                <p class="description">
                    Makalelere otomatik resim eklemek için en az bir resim servisi API anahtarı gereklidir. 
                    <strong>Hepsi tamamen ücretsiz!</strong>
                </p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label>Pexels (ÖNERİLEN)</label>
                        </th>
                        <td>
                            <input type="password" 
                                   name="mimoza_pexels_api_key" 
                                   value="<?php echo esc_attr(get_option('mimoza_pexels_api_key')); ?>" 
                                   class="regular-text api-key-input" 
                                   placeholder="563492ad6f917..." />
                            <button type="button" class="button toggle-password">👁️</button>
                            <p class="description">
                                <a href="https://www.pexels.com/api/" target="_blank">
                                    Ücretsiz API Anahtarı Al →
                                </a>
                                <strong>Tamamen ücretsiz!</strong>
                            </p>
                            <?php if (get_option('mimoza_pexels_api_key')): ?>
                                <span style="color: green;">✓ Kayıtlı</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Boş</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label>Unsplash</label>
                        </th>
                        <td>
                            <input type="password" 
                                   name="mimoza_unsplash_api_key" 
                                   value="<?php echo esc_attr(get_option('mimoza_unsplash_api_key')); ?>" 
                                   class="regular-text api-key-input" 
                                   placeholder="Client-ID ..." />
                            <button type="button" class="button toggle-password">👁️</button>
                            <p class="description">
                                <a href="https://unsplash.com/developers" target="_blank">
                                    Ücretsiz API Anahtarı Al →
                                </a>
                            </p>
                            <?php if (get_option('mimoza_unsplash_api_key')): ?>
                                <span style="color: green;">✓ Kayıtlı</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Boş</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label>Pixabay</label>
                        </th>
                        <td>
                            <input type="password" 
                                   name="mimoza_pixabay_api_key" 
                                   value="<?php echo esc_attr(get_option('mimoza_pixabay_api_key')); ?>" 
                                   class="regular-text api-key-input" 
                                   placeholder="12345678-..." />
                            <button type="button" class="button toggle-password">👁️</button>
                            <p class="description">
                                <a href="https://pixabay.com/api/docs/" target="_blank">
                                    Ücretsiz API Anahtarı Al →
                                </a>
                            </p>
                            <?php if (get_option('mimoza_pixabay_api_key')): ?>
                                <span style="color: green;">✓ Kayıtlı</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Boş</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Sistem Bilgileri -->
            <div class="settings-section">
                <h2>ℹ️ Sistem Bilgileri</h2>
                <table class="widefat">
                    <tr>
                        <td width="30%"><strong>Plugin Versiyonu:</strong></td>
                        <td><?php echo MIMOZA_VERSION; ?></td>
                    </tr>
                    <tr>
                        <td><strong>WordPress Versiyonu:</strong></td>
                        <td><?php echo get_bloginfo('version'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>PHP Versiyonu:</strong></td>
                        <td>
                            <?php echo PHP_VERSION; ?>
                            <?php if (version_compare(PHP_VERSION, '7.4.0') >= 0): ?>
                                <span style="color: green;">✓ Uyumlu</span>
                            <?php else: ?>
                                <span style="color: red;">✗ PHP 7.4+ gerekli!</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Memory Limit:</strong></td>
                        <td><?php echo ini_get('memory_limit'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Max Execution Time:</strong></td>
                        <td><?php echo ini_get('max_execution_time'); ?> saniye</td>
                    </tr>
                    <tr>
                        <td><strong>cURL:</strong></td>
                        <td>
                            <?php if (function_exists('curl_version')): ?>
                                <span style="color: green;">✓ Yüklü (<?php echo curl_version()['version']; ?>)</span>
                            <?php else: ?>
                                <span style="color: red;">✗ Yüklü değil - Hosting'den cURL aktifleştirmesini isteyin!</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Yoast SEO:</strong></td>
                        <td><?php echo defined('WPSEO_VERSION') ? '✓ Aktif (v' . WPSEO_VERSION . ')' : '✗ Yüklü değil'; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Rank Math:</strong></td>
                        <td><?php echo class_exists('RankMath') ? '✓ Aktif' : '✗ Yüklü değil'; ?></td>
                    </tr>
                </table>
            </div>
            
        </div>
        
        <p class="submit">
            <button type="submit" name="mimoza_save_settings" class="button button-primary button-hero">
                💾 Ayarları Kaydet
            </button>
        </p>
    </form>
</div>

<style>
.mimoza-settings {
    max-width: 1000px;
}

.settings-container {
    margin: 30px 0;
}

.settings-section {
    background: white;
    padding: 25px;
    border-radius: 10px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    margin-bottom: 30px;
}

.settings-section h2 {
    margin-top: 0;
    border-bottom: 2px solid #f0f0f0;
    padding-bottom: 15px;
}

.form-table th {
    width: 200px;
    font-weight: 600;
}

.api-key-input {
    font-family: monospace;
    letter-spacing: 1px;
}

.toggle-password {
    margin-left: 5px;
    cursor: pointer;
}

.form-table .description {
    margin-top: 8px;
    font-size: 13px;
}

.form-table .description a {
    font-weight: 600;
    text-decoration: none;
}

.widefat td {
    padding: 12px;
}

.button-hero {
    padding: 15px 40px !important;
    font-size: 16px !important;
    height: auto !important;
}
</style>

<script>
jQuery(document).ready(function($) {
    // Şifre göster/gizle
    $('.toggle-password').on('click', function() {
        var input = $(this).prev('.api-key-input');
        var type = input.attr('type');
        
        if (!type || type === 'password') {
            input.attr('type', 'text');
            $(this).text('🙈');
        } else {
            input.attr('type', 'password');
            $(this).text('👁️');
        }
    });
});
</script>