<?php
if (!defined('ABSPATH')) exit;

// Başarı mesajı
if (isset($_GET['generated'])) {
    $count = intval($_GET['count']);
    echo '<div class="notice notice-success is-dismissible"><p><strong>✓ Başarılı!</strong> ' . $count . ' makale oluşturuldu.</p></div>';
}

// Hata mesajı
if (isset($_GET['error'])) {
    $error = sanitize_text_field($_GET['error']);
    echo '<div class="notice notice-error is-dismissible"><p><strong>✗ Hata:</strong> ' . $error . '</p></div>';
}
?>

<div class="wrap mimoza-content-generator">
    <h1>🚀 Mimoza AI SEO - İçerik Üretici</h1>
    
    <div class="mimoza-info-box">
        <h3>✨ Sınırsız Kullanım - Tamamen Ücretsiz!</h3>
        <p>İstediğiniz kadar makale üretebilirsiniz. Hiçbir limit yok!</p>
    </div>
    
    <!-- API Kontrol Uyarısı -->
    <?php
    $has_ai_api = get_option('mimoza_openai_api_key') || 
                  get_option('mimoza_claude_api_key') || 
                  get_option('mimoza_gemini_api_key');
    
    if (!$has_ai_api):
    ?>
    <div class="notice notice-error">
        <p>
            <strong>❌ Hata:</strong> Hiç AI API anahtarı girilmemiş! 
            <a href="<?php echo admin_url('admin.php?page=mimoza-settings'); ?>">
                Ayarlar sayfasından en az bir AI API anahtarı ekleyin.
            </a>
        </p>
    </div>
    <?php return; endif; ?>
    
    <!-- İçerik Üretim Formu -->
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" id="mimoza-content-form" class="mimoza-form">
        <?php wp_nonce_field('mimoza_bulk_generate_action', 'mimoza_bulk_generate_nonce'); ?>
        <input type="hidden" name="action" value="mimoza_bulk_generate" />
        
        <div class="form-grid">
            <!-- Sol Kolon -->
            <div class="form-column">
                <div class="form-section">
                    <h2>📝 Anahtar Kelimeler</h2>
                    <textarea 
                        name="keywords" 
                        rows="8" 
                        class="widefat" 
                        placeholder="Her satıra bir anahtar kelime&#10;&#10;Örnek:&#10;yapay zeka nedir&#10;seo optimizasyonu&#10;wordpress eklentisi"
                        required
                    ></textarea>
                    <p class="description">
                        <strong>Sınırsız makale üretimi!</strong> İstediğiniz kadar anahtar kelime ekleyin.
                    </p>
                </div>
                
                <div class="form-section">
                    <h2>💬 Özel Prompt (İsteğe Bağlı)</h2>
                    <textarea 
                        name="custom_prompt" 
                        rows="6" 
                        class="widefat" 
                        placeholder="Kendi prompt'unuzu yazın. Boş bırakırsanız varsayılan SEO uyumlu prompt kullanılır.&#10;&#10;Örnek:&#10;{keyword} hakkında eğlenceli ve samimi bir yazı yaz. Günlük konuşma tarzında ol."
                    ></textarea>
                    <p class="description">
                        <strong>💡 İpucu:</strong> Prompt içinde <code>{keyword}</code> yazarsanız, anahtar kelime ile değiştirilir.<br>
                        <strong>🎯 Boş bırakırsanız:</strong> Otomatik SEO uyumlu, profesyonel makale oluşturulur.
                    </p>
                </div>
                
                <div class="form-section">
                    <h2>🤖 AI Modeli</h2>
                    <select name="ai_model" class="widefat" required>
                        <?php if (get_option('mimoza_gemini_api_key')): ?>
                        <option value="gemini-1.0-pro" selected>Gemini 1.0 Pro (Ücretsiz)</option>
                        <option value="gemini-1.5-pro">Gemini 1.5 Pro</option>
                        <?php endif; ?>
                        <?php if (get_option('mimoza_openai_api_key')): ?>
                        <option value="gpt-3.5-turbo">GPT-3.5 Turbo (Hızlı)</option>
                        <option value="gpt-4">GPT-4 (En Kaliteli)</option>
                        <?php endif; ?>
                        <?php if (get_option('mimoza_claude_api_key')): ?>
                        <option value="claude-3-haiku">Claude 3 Haiku</option>
                        <option value="claude-3-sonnet">Claude 3 Sonnet</option>
                        <?php endif; ?>
                    </select>
                </div>
                
                <div class="form-section">
                    <h2>📏 Makale Uzunluğu</h2>
                    <input 
                        type="number" 
                        name="word_count" 
                        value="2000" 
                        min="500" 
                        max="5000" 
                        step="100"
                        class="widefat"
                    />
                    <p class="description">
                        500 - 5000 kelime arası (Önerilen: 2000)
                    </p>
                </div>
            </div>
            
            <!-- Sağ Kolon -->
            <div class="form-column">
                <div class="form-section">
                    <h2>🖼️ Resim Ayarları</h2>
                    <label>
                        <input type="checkbox" name="use_images" value="1" checked />
                        Otomatik resim ekle
                    </label>
                    <br><br>
                    <select name="image_provider" class="widefat">
                        <option value="pexels">Pexels (Ücretsiz)</option>
                        <option value="unsplash">Unsplash (Ücretsiz)</option>
                        <option value="pixabay">Pixabay (Ücretsiz)</option>
                    </select>
                </div>
                
                <div class="form-section">
                    <h2>🗂️ Kategoriler</h2>
                    <select name="categories[]" class="widefat" multiple size="5">
                        <?php
                        $categories = get_categories(['hide_empty' => false]);
                        foreach ($categories as $category) {
                            echo '<option value="' . $category->term_id . '">' . esc_html($category->name) . '</option>';
                        }
                        ?>
                    </select>
                    <p class="description">Ctrl tuşuna basılı tutarak birden fazla seçin</p>
                </div>
                
                <div class="form-section">
                    <h2>📅 Yayınlama Seçeneği</h2>
                    <select name="publish_option" class="widefat">
                        <option value="draft">Taslak olarak kaydet</option>
                        <option value="publish">Hemen yayınla</option>
                        <option value="future">Zamanla (Her gün sırayla)</option>
                    </select>
                </div>
            </div>
        </div>
        
        <!-- Üretim Butonu -->
        <div class="form-actions">
            <button type="submit" class="button button-primary button-hero" id="generate-button">
                🚀 Makaleleri Oluştur
            </button>
            <p class="description" style="margin-top: 15px;">
                ⏱️ Her makale yaklaşık 30-60 saniye sürer. Sayfadan ayrılmayın.
            </p>
        </div>
    </form>
</div>

<style>
.mimoza-info-box {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    border-radius: 10px;
    margin: 20px 0;
    text-align: center;
}

.mimoza-info-box h3 {
    margin: 0 0 10px 0;
    font-size: 24px;
}

.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
    margin: 30px 0;
}

.form-section {
    background: white;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    margin-bottom: 20px;
}

.form-section h2 {
    margin-top: 0;
    font-size: 16px;
    border-bottom: 2px solid #f0f0f0;
    padding-bottom: 10px;
}

.form-actions {
    text-align: center;
    padding: 30px 0;
}

.button-hero {
    padding: 15px 40px !important;
    font-size: 18px !important;
    height: auto !important;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

@media (max-width: 768px) {
    .form-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    $('#mimoza-content-form').on('submit', function(e) {
        var keywords = $('textarea[name="keywords"]').val().trim();
        
        if (!keywords) {
            alert('⚠️ Lütfen en az bir anahtar kelime girin!');
            e.preventDefault();
            return false;
        }
        
        var keywordCount = keywords.split('\n').filter(k => k.trim()).length;
        
        if (!confirm('📝 ' + keywordCount + ' makale oluşturulacak.\n\n⏱️ Tahmini süre: ' + Math.ceil(keywordCount * 0.5) + ' dakika\n\nDevam etmek istiyor musunuz?')) {
            e.preventDefault();
            return false;
        }
        
        var $button = $('#generate-button');
        $button.prop('disabled', true).html('⏳ Oluşturuluyor... (' + keywordCount + ' makale)');
    });
});
</script>
