<?php
if (!defined('ABSPATH')) exit;

$link_manager = new Mimoza_Link_Manager();
$links = $link_manager->get_all_links();
?>

<div class="wrap mimoza-link-pool">
    <h1>🔗 Link Havuzu Yönetimi</h1>
    
    <p class="description">
        Makalelerde otomatik olarak kullanılacak linkleri buradan yönetin. 
        Her makalede 2-5 link rastgele seçilip içeriğe doğal şekilde eklenir.
    </p>
    
    <div class="link-tabs">
        <button class="tab-button active" data-tab="internal">🏠 İç Linkler</button>
        <button class="tab-button" data-tab="external">🌐 Dış Linkler</button>
        <button class="tab-button" data-tab="import">📥 İçe/Dışa Aktar</button>
    </div>
    
    <!-- İç Linkler -->
    <div id="internal-links" class="tab-content active">
        <div class="link-section">
            <h2>İç Link Ekle</h2>
            <form id="add-internal-link" class="add-link-form">
                <input type="text" name="anchor" placeholder="Çapa metin (ör: seo optimizasyonu)" required />
                <input type="url" name="url" placeholder="URL (ör: https://siteniz.com/seo)" required />
                <button type="submit" class="button button-primary">Ekle</button>
            </form>
        </div>
        
        <div class="links-list">
            <h3>Kayıtlı İç Linkler (<?php echo count($links['internal']); ?>)</h3>
            <?php if (empty($links['internal'])): ?>
                <p class="no-links">Henüz link eklenmemiş.</p>
            <?php else: ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th width="40%">Çapa Metin</th>
                            <th width="50%">URL</th>
                            <th width="10%">İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($links['internal'] as $index => $link): ?>
                        <tr>
                            <td><?php echo esc_html($link['anchor']); ?></td>
                            <td>
                                <a href="<?php echo esc_url($link['url']); ?>" target="_blank">
                                    <?php echo esc_html($link['url']); ?>
                                </a>
                            </td>
                            <td>
                                <button class="button button-small delete-link" 
                                        data-index="<?php echo $index; ?>" 
                                        data-type="internal">
                                    Sil
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Dış Linkler -->
    <div id="external-links" class="tab-content">
        <div class="link-section">
            <h2>Dış Link Ekle</h2>
            <form id="add-external-link" class="add-link-form">
                <input type="text" name="anchor" placeholder="Çapa metin (ör: yapay zeka rehberi)" required />
                <input type="url" name="url" placeholder="URL (ör: https://external.com/ai-guide)" required />
                <button type="submit" class="button button-primary">Ekle</button>
            </form>
            <p class="description">
                <strong>Not:</strong> Dış linklere otomatik olarak rel="nofollow noopener" eklenir.
            </p>
        </div>
        
        <div class="links-list">
            <h3>Kayıtlı Dış Linkler (<?php echo count($links['external']); ?>)</h3>
            <?php if (empty($links['external'])): ?>
                <p class="no-links">Henüz link eklenmemiş.</p>
            <?php else: ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th width="40%">Çapa Metin</th>
                            <th width="50%">URL</th>
                            <th width="10%">İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($links['external'] as $index => $link): ?>
                        <tr>
                            <td><?php echo esc_html($link['anchor']); ?></td>
                            <td>
                                <a href="<?php echo esc_url($link['url']); ?>" target="_blank" rel="nofollow noopener">
                                    <?php echo esc_html($link['url']); ?>
                                </a>
                            </td>
                            <td>
                                <button class="button button-small delete-link" 
                                        data-index="<?php echo $index; ?>" 
                                        data-type="external">
                                    Sil
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- İçe/Dışa Aktar -->
    <div id="import-export" class="tab-content">
        <div class="import-export-section">
            <div class="ie-box">
                <h2>📥 CSV'den İçe Aktar</h2>
                <p>Format: Çapa Metin, URL, Tip (internal/external)</p>
                <form id="import-csv-form" enctype="multipart/form-data">
                    <input type="file" name="csv_file" accept=".csv" required />
                    <button type="submit" class="button button-primary">İçe Aktar</button>
                </form>
            </div>
            
            <div class="ie-box">
                <h2>📤 CSV'ye Dışa Aktar</h2>
                <p>Tüm linklerinizi CSV dosyası olarak indirin.</p>
                <a href="<?php echo admin_url('admin-ajax.php?action=mimoza_export_links&type=all&nonce=' . wp_create_nonce('mimoza_nonce')); ?>" 
                   class="button button-secondary">
                    Tüm Linkleri Dışa Aktar
                </a>
                <a href="<?php echo admin_url('admin-ajax.php?action=mimoza_export_links&type=internal&nonce=' . wp_create_nonce('mimoza_nonce')); ?>" 
                   class="button button-secondary">
                    Sadece İç Linkler
                </a>
                <a href="<?php echo admin_url('admin-ajax.php?action=mimoza_export_links&type=external&nonce=' . wp_create_nonce('mimoza_nonce')); ?>" 
                   class="button button-secondary">
                    Sadece Dış Linkler
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.mimoza-link-pool {
    max-width: 1200px;
}

.link-tabs {
    display: flex;
    gap: 10px;
    margin: 20px 0;
    border-bottom: 2px solid #ddd;
}

.tab-button {
    padding: 12px 24px;
    background: white;
    border: 1px solid #ddd;
    border-bottom: none;
    cursor: pointer;
    border-radius: 5px 5px 0 0;
    transition: all 0.3s;
}

.tab-button:hover {
    background: #f5f5f5;
}

.tab-button.active {
    background: #667eea;
    color: white;
    border-color: #667eea;
}

.tab-content {
    display: none;
    padding: 30px;
    background: white;
    border: 1px solid #ddd;
    border-top: none;
    border-radius: 0 0 10px 10px;
}

.tab-content.active {
    display: block;
}

.link-section {
    background: #f9f9f9;
    padding: 20px;
    border-radius: 10px;
    margin-bottom: 30px;
}

.add-link-form {
    display: flex;
    gap: 10px;
    align-items: center;
}

.add-link-form input {
    flex: 1;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 5px;
}

.links-list h3 {
    margin-bottom: 15px;
}

.no-links {
    text-align: center;
    padding: 40px;
    color: #999;
    font-style: italic;
}

.import-export-section {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
}

.ie-box {
    background: #f9f9f9;
    padding: 25px;
    border-radius: 10px;
}

.ie-box h2 {
    margin-top: 0;
}

#import-csv-form {
    display: flex;
    flex-direction: column;
    gap: 15px;
}
</style>

<script>
jQuery(document).ready(function($) {
    // Tab değiştirme
    $('.tab-button').on('click', function() {
        var tab = $(this).data('tab');
        
        $('.tab-button').removeClass('active');
        $(this).addClass('active');
        
        $('.tab-content').removeClass('active');
        $('#' + tab + '-links, #import-export').filter(function() {
            return $(this).attr('id').indexOf(tab) === 0 || tab === 'import';
        }).addClass('active');
    });
    
    // Link ekleme - İç
    $('#add-internal-link').on('submit', function(e) {
        e.preventDefault();
        addLink('internal', $(this));
    });
    
    // Link ekleme - Dış
    $('#add-external-link').on('submit', function(e) {
        e.preventDefault();
        addLink('external', $(this));
    });
    
    function addLink(type, form) {
        var data = {
            action: 'mimoza_add_link',
            nonce: '<?php echo wp_create_nonce('mimoza_nonce'); ?>',
            type: type,
            anchor: form.find('input[name="anchor"]').val(),
            url: form.find('input[name="url"]').val()
        };
        
        $.post(ajaxurl, data, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Hata: ' + response.data);
            }
        });
    }
    
    // Link silme
    $('.delete-link').on('click', function() {
        if (!confirm('Bu linki silmek istediğinize emin misiniz?')) {
            return;
        }
        
        var index = $(this).data('index');
        var type = $(this).data('type');
        
        $.post(ajaxurl, {
            action: 'mimoza_delete_link',
            nonce: '<?php echo wp_create_nonce('mimoza_nonce'); ?>',
            index: index,
            type: type
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Hata: ' + response.data);
            }
        });
    });
});
</script>