<?php
/**
 * Premium'a Yükseltme Widget'ı
 */

if (!defined('ABSPATH')) exit;

class Mimoza_Upgrade_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'mimoza_upgrade_widget',
            '⭐ Mimoza - Premium Yükselt',
            ['description' => 'Kullanıcıları premium sürüme yönlendirir']
        );
    }
    
    public function widget($args, $instance) {
        $license_manager = new Mimoza_License_Manager();
        $license_data = $license_manager->get_license_data();
        
        // Premium kullanıcılara gösterme
        if ($license_data['type'] !== 'free') {
            return;
        }
        
        $limit_check = $license_manager->check_generation_limit();
        $percentage = ($limit_check['used'] / $limit_check['limit']) * 100;
        
        echo $args['before_widget'];
        ?>
        <div class="mimoza-upgrade-widget">
            <div class="widget-icon">🚀</div>
            <h3>Premium'a Yükselt!</h3>
            
            <div class="usage-bar">
                <div class="usage-fill" style="width: <?php echo $percentage; ?>%;"></div>
            </div>
            
            <p class="usage-text">
                <strong><?php echo $limit_check['used']; ?></strong> / <?php echo $limit_check['limit']; ?> makale kullanıldı
            </p>
            
            <ul class="premium-benefits">
                <li>✅ Aylık 100 makale</li>
                <li>✅ Tüm AI modelleri</li>
                <li>✅ Zamanlama</li>
                <li>✅ Link havuzu</li>
            </ul>
            
            <a href="<?php echo home_url('/lisans-satin-al/'); ?>" class="widget-btn">
                💎 Premium'a Geç
            </a>
            
            <p class="widget-note">İlk 14 gün iade garantili!</p>
        </div>
        
        <style>
        .mimoza-upgrade-widget {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            border-radius: 15px;
            text-align: center;
        }
        
        .widget-icon {
            font-size: 48px;
            margin-bottom: 15px;
        }
        
        .mimoza-upgrade-widget h3 {
            margin: 0 0 20px 0;
            color: white;
        }
        
        .usage-bar {
            background: rgba(255,255,255,0.3);
            height: 30px;
            border-radius: 15px;
            overflow: hidden;
            margin-bottom: 10px;
        }
        
        .usage-fill {
            background: white;
            height: 100%;
            border-radius: 15px;
            transition: width 0.5s;
        }
        
        .usage-text {
            font-size: 14px;
            margin-bottom: 20px;
            opacity: 0.9;
        }
        
        .premium-benefits {
            list-style: none;
            padding: 0;
            margin: 20px 0;
            text-align: left;
        }
        
        .premium-benefits li {
            padding: 8px 0;
            border-bottom: 1px solid rgba(255,255,255,0.2);
        }
        
        .widget-btn {
            display: block;
            background: white;
            color: #667eea;
            padding: 15px 30px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: bold;
            margin: 20px 0 10px 0;
            transition: transform 0.3s;
        }
        
        .widget-btn:hover {
            transform: translateY(-3px);
        }
        
        .widget-note {
            font-size: 12px;
            opacity: 0.8;
            margin: 0;
        }
        </style>
        <?php
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        ?>
        <p>
            <em>Bu widget otomatik olarak premium olmayan kullanıcılara gösterilir.</em>
        </p>
        <?php
    }
}