# Mimoza AI SEO Premium v6.0 - Kurulum ve Kullanım Kılavuzu

## 🚀 Yeni Özellikler (v6.0)

### Modern AI Motorları Entegrasyonu
- **ChatGPT-5 / GPT-4o**: OpenAI'ın en gelişmiş modeli
- **Claude Sonnet 4.5**: Anthropic'in en akıllı ve hızlı modeli (ÖNERİLEN)
- **Gemini 2.0 Flash**: Google'ın ücretsiz kullanımlı deneysel modeli
- **Jasper AI**: Marketing ve copywriting odaklı premium model

### Akıllı Prompt Sistemi
- ✅ Kullanıcı niyeti analizi
- ✅ Bağlam koruma ve anlam kaybı önleme
- ✅ Özel prompt desteği ({keyword} placeholder)
- ✅ SEO odaklı varsayılan prompt şablonları

### Otomatik Linking Sistemi
- ✅ **Internal Linking**: Site içi ilgili makalelere otomatik 3-5 link
- ✅ **External Linking**: Wikipedia, Google, Ahrefs gibi yüksek otoriteli sitelere 1-3 link
- ✅ Doğal anchor text kullanımı
- ✅ Link havuzu yönetimi

### Gelişmiş SEO Otomasyonu
- ✅ Otomatik meta title (55 karakter, SEO uyumlu)
- ✅ Otomatik meta description (130 karakter)
- ✅ H1-H3 başlık yapısı otomasyonu
- ✅ Schema markup (Article + FAQ)
- ✅ Yoast SEO, Rank Math, All in One SEO uyumlu

## 📦 Kurulum

### 1. Eklentiyi Yükleyin
```bash
1. WordPress admin paneline giriş yapın
2. Eklentiler > Yeni Ekle > Eklenti Yükle
3. mimoza-ai-seo-premium-v6.zip dosyasını seçin
4. "Şimdi Yükle" ve ardından "Etkinleştir" butonuna tıklayın
```

### 2. API Anahtarlarını Ekleyin
```
Mimoza AI SEO > Ayarlar sayfasından en az bir AI API anahtarı ekleyin:
```

#### OpenAI API Key (GPT-4o)
1. https://platform.openai.com/api-keys adresine gidin
2. "Create new secret key" butonuna tıklayın
3. Anahtarı kopyalayın ve ayarlara yapıştırın

#### Claude API Key (ÖNERİLEN)
1. https://console.anthropic.com/ adresine gidin
2. "Get API Keys" sekmesine tıklayın
3. "Create Key" butonuna basın
4. Anahtarı kopyalayın ve ayarlara yapıştırın

#### Gemini API Key (ÜCRETSİZ)
1. https://makersuite.google.com/app/apikey adresine gidin
2. "Create API Key" butonuna tıklayın
3. Anahtarı kopyalayın ve ayarlara yapıştırın

#### Jasper API Key (Opsiyonel)
1. https://app.jasper.ai/ adresine gidin
2. Settings > API sekmesine tıklayın
3. "Generate API Key" butonuna basın

## 🎯 Kullanım

### Temel Kullanım
1. **Mimoza AI SEO > İçerik Üretici** sayfasına gidin
2. Anahtar kelimelerinizi her satıra bir tane olacak şekilde girin
3. AI modelini seçin (Claude Sonnet 4.5 önerilir)
4. Makale uzunluğunu belirleyin (2000 kelime önerilir)
5. "Makaleleri Oluştur" butonuna tıklayın

### Gelişmiş Kullanım

#### Özel Prompt Kullanımı
```
Özel prompt alanına kendi talimatlarınızı yazabilirsiniz:

Örnek 1 - Teknik Yazı:
{keyword} konusunda teknik bir makale yaz. Kod örnekleri ve best practices içersin.

Örnek 2 - Blog Yazısı:
{keyword} hakkında samimi ve eğlenceli bir blog yazısı. Günlük konuşma tarzında ol.

Örnek 3 - Eğitim İçeriği:
{keyword} konusunu adım adım öğreten bir rehber. Başlangıç seviyesine uygun.
```

#### Link Havuzu Yönetimi
1. **Mimoza AI SEO > Link Havuzu** sayfasına gidin
2. Internal ve External linkleri ekleyin
3. Çapa metni ve URL girin
4. Bu linkler otomatik olarak makalelere eklenecek

## 🔧 Gelişmiş Özellikler

### 1. Otomatik Internal Linking
```php
// Sistem otomatik olarak:
- Site içindeki ilgili makaleleri bulur
- Doğal anchor text'ler kullanır
- Her makalede 3-5 internal link ekler
```

### 2. Otomatik External Linking
```php
// Yüksek otoriteli siteler:
- Wikipedia (TR/EN)
- Google Developers
- Google Search Console
- Ahrefs Blog
- Moz Blog
- Link havuzundaki external linkler
```

### 3. SEO Schema Markup
```json
// Otomatik eklenir:
{
  "@type": "Article",
  "headline": "Makale Başlığı",
  "description": "Meta açıklama",
  "author": { ... },
  "publisher": { ... }
}

// FAQ varsa:
{
  "@type": "FAQPage",
  "mainEntity": [ ... ]
}
```

## 💡 En İyi Uygulamalar

### Model Seçimi
- **SEO içerik için**: Claude Sonnet 4.5 (en dengeli)
- **Yaratıcı içerik için**: GPT-4o
- **Hızlı test için**: Gemini 2.0 Flash (ücretsiz)
- **Marketing için**: Jasper Pro

### Kelime Sayısı
- **Kısa yazılar**: 800-1200 kelime
- **Blog yazıları**: 1500-2000 kelime ⭐ Önerilen
- **Uzun rehberler**: 2500-3500 kelime
- **Kapsamlı kılavuzlar**: 4000-5000 kelime

### Linking Stratejisi
- Her makalede 3-5 internal link
- 1-3 yüksek otoriteli external link
- Doğal anchor text kullanımı
- Spam'den kaçının

## 🎨 Desteklenen SEO Eklentileri

✅ **Yoast SEO**: Meta title, description, focus keyword
✅ **Rank Math**: Tüm SEO meta verileri
✅ **All in One SEO**: Title ve description
✅ **Schema markup**: Article, FAQ (tüm temalarla uyumlu)

## 📊 Performans İpuçları

### Token Kullanımı
```
GPT-4o: ~$0.03 per 2000 kelime
Claude Sonnet 4.5: ~$0.006 per 2000 kelime ⭐ En Ekonomik
Gemini 2.0 Flash: Ücretsiz kotası var
Jasper Pro: Sabit aylık ücret
```

### Hız Optimizasyonu
- Claude Sonnet 4.5: ~30-45 saniye/makale ⚡
- GPT-4o: ~45-60 saniye/makale
- Gemini 2.0 Flash: ~20-30 saniye/makale
- Jasper Pro: ~40-50 saniye/makale

## ⚠️ Sık Sorulan Sorular

### Q: API anahtarım çalışmıyor?
A: API anahtarınızın:
- Doğru kopyalandığından emin olun (boşluk olmamalı)
- Hesabınızda kredi/limit olduğunu kontrol edin
- Doğru provider'ı (OpenAI/Claude/Gemini) seçtiğinizden emin olun

### Q: Makaleler kısa çıkıyor?
A: 
- Kelime sayısını artırın (en az 1500)
- Özel prompt kullanarak daha detaylı talimat verin
- Claude Sonnet 4.5 veya GPT-4o kullanın

### Q: Internal linkler eklenmiyor?
A: 
- Link havuzuna linkler ekleyin
- Site içinde yayınlanmış makaleler olduğundan emin olun
- "Internal Linkler Otomatik Eklensin" seçeneğinin aktif olduğunu kontrol edin

### Q: Hangi model en iyi?
A: 
- **Genel kullanım**: Claude Sonnet 4.5 (hız + kalite + fiyat dengesi)
- **Maksimum kalite**: GPT-4o veya Claude 3 Opus
- **Deneme/Test**: Gemini 2.0 Flash (ücretsiz)
- **Marketing**: Jasper Pro

## 🔄 Güncelleme Notları

### v6.0 (Mevcut)
- ✅ Claude Sonnet 4.5 desteği
- ✅ GPT-4o desteği
- ✅ Gemini 2.0 Flash desteği
- ✅ Jasper AI entegrasyonu
- ✅ Akıllı prompt sistemi
- ✅ Otomatik linking sistemi
- ✅ Gelişmiş SEO otomasyonu
- ✅ Schema markup (Article + FAQ)

### v5.1 (Eski)
- OpenAI GPT-3.5/4 desteği
- Claude 3 desteği
- Gemini 1.0 desteği
- Temel SEO optimizasyonu

## 📞 Destek

### Teknik Destek
- Email: support@mimoza.com.tr
- Dokümantasyon: https://docs.mimoza.com.tr

### Topluluk
- Discord: https://discord.gg/mimoza
- Forum: https://forum.mimoza.com.tr

## 📝 Lisans

GPL v2 or later

## 👨‍💻 Geliştirici

**Mimoza Bilişim**
- Website: https://mimoza.com.tr
- GitHub: https://github.com/mimoza

---

## 🎉 Başarılar Dileriz!

Mimoza AI SEO Premium v6.0 ile profesyonel, SEO uyumlu içerikler üretin! 🚀
