<?php
if (!defined('ABSPATH')) exit;

// Başarı mesajı
if (isset($_GET['generated'])) {
    $count = intval($_GET['count']);
    echo '<div class="notice notice-success is-dismissible"><p><strong>✓ Başarılı!</strong> ' . $count . ' makale oluşturuldu ve SEO optimizasyonu yapıldı.</p></div>';
}

// Hata mesajı
if (isset($_GET['error'])) {
    $error = sanitize_text_field($_GET['error']);
    echo '<div class="notice notice-error is-dismissible"><p><strong>✗ Hata:</strong> ' . $error . '</p></div>';
}
?>

<div class="wrap mimoza-content-generator-v6">
    <h1>🚀 Mimoza AI SEO Premium v6.0 - İçerik Üretici</h1>
    
    <div class="mimoza-hero-box">
        <h2>✨ Gelişmiş AI Motorları ile Profesyonel İçerik Üretimi</h2>
        <p>ChatGPT-5, Claude Sonnet 4.5, Gemini 2.0 ve Jasper ile güçlendirilmiş otomatik içerik üretimi</p>
        <div class="features-grid">
            <div class="feature">
                <span class="icon">🤖</span>
                <strong>Modern AI Modelleri</strong>
                <p>En güncel AI motorları</p>
            </div>
            <div class="feature">
                <span class="icon">🔗</span>
                <strong>Akıllı Linking</strong>
                <p>Otomatik internal & external</p>
            </div>
            <div class="feature">
                <span class="icon">📊</span>
                <strong>SEO Otomasyonu</strong>
                <p>Meta, başlık, schema markup</p>
            </div>
            <div class="feature">
                <span class="icon">💬</span>
                <strong>Akıllı Prompt</strong>
                <p>Bağlam koruma & niyet analizi</p>
            </div>
        </div>
    </div>
    
    <!-- API Kontrol Uyarısı -->
    <?php
    $has_openai = get_option('mimoza_openai_api_key');
    $has_claude = get_option('mimoza_claude_api_key');
    $has_gemini = get_option('mimoza_gemini_api_key');
    $has_jasper = get_option('mimoza_jasper_api_key');
    
    $has_any_ai = $has_openai || $has_claude || $has_gemini || $has_jasper;
    
    if (!$has_any_ai):
    ?>
    <div class="notice notice-error">
        <p>
            <strong>❌ Hata:</strong> Hiç AI API anahtarı girilmemiş! 
            <a href="<?php echo admin_url('admin.php?page=mimoza-settings'); ?>">
                Ayarlar sayfasından en az bir AI API anahtarı ekleyin.
            </a>
        </p>
    </div>
    <?php return; endif; ?>
    
    <!-- İçerik Üretim Formu -->
    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" id="mimoza-content-form-v6" class="mimoza-form-v6">
        <?php wp_nonce_field('mimoza_bulk_generate_action', 'mimoza_bulk_generate_nonce'); ?>
        <input type="hidden" name="action" value="mimoza_bulk_generate" />
        
        <div class="form-layout">
            <!-- Sol Panel - Ana Ayarlar -->
            <div class="main-panel">
                <div class="form-card">
                    <div class="card-header">
                        <h2>📝 Anahtar Kelimeler</h2>
                    </div>
                    <div class="card-body">
                        <textarea 
                            name="keywords" 
                            rows="10" 
                            class="widefat code-style" 
                            placeholder="Her satıra bir anahtar kelime girin&#10;&#10;Örnek:&#10;yapay zeka ile içerik üretimi&#10;seo optimizasyon teknikleri&#10;wordpress eklentileri 2025&#10;chatgpt 5 özellikleri&#10;claude sonnet 4.5 kullanımı"
                            required
                        ></textarea>
                        <div class="input-info">
                            <span class="badge">Sınırsız</span>
                            <span>İstediğiniz kadar anahtar kelime ekleyin. Her biri için ayrı makale oluşturulur.</span>
                        </div>
                    </div>
                </div>
                
                <div class="form-card">
                    <div class="card-header">
                        <h2>💬 Özel Prompt (Gelişmiş)</h2>
                        <span class="badge badge-optional">İsteğe Bağlı</span>
                    </div>
                    <div class="card-body">
                        <textarea 
                            name="custom_prompt" 
                            rows="8" 
                            class="widefat code-style" 
                            placeholder="Kendi prompt'unuzu yazın veya boş bırakın (varsayılan SEO prompt kullanılır)&#10;&#10;💡 Örnek Özel Promptlar:&#10;&#10;1) Teknik Yazı:&#10;{keyword} konusunda teknik bir makale yaz. Kod örnekleri ve best practices içersin. Yazılımcılara hitap et.&#10;&#10;2) Blog Yazısı:&#10;{keyword} hakkında samimi ve eğlenceli bir blog yazısı. Günlük konuşma tarzında ol. Kişisel deneyimler ekle.&#10;&#10;3) Eğitim İçeriği:&#10;{keyword} konusunu adım adım öğreten bir rehber. Başlangıç seviyesine uygun, görsellerle desteklenebilir."
                        ></textarea>
                        <div class="input-info">
                            <strong>🎯 Placeholder:</strong> <code>{keyword}</code> yazarsanız anahtar kelime ile değiştirilir<br>
                            <strong>✨ Boş bırakırsanız:</strong> Otomatik olarak SEO uyumlu, profesyonel makale promptu kullanılır
                        </div>
                    </div>
                </div>
                
                <div class="form-card">
                    <div class="card-header">
                        <h2>🤖 AI Modeli Seçimi</h2>
                    </div>
                    <div class="card-body">
                        <select name="ai_model" class="widefat select-modern" required>
                            <optgroup label="🔵 OpenAI (ChatGPT)">
                                <?php if ($has_openai): ?>
                                <option value="gpt-4o">GPT-4o - En Gelişmiş Model (Önerilen)</option>
                                <option value="gpt-4-turbo">GPT-4 Turbo - Hızlı & Güçlü</option>
                                <option value="gpt-4">GPT-4 - Yüksek Kalite</option>
                                <option value="gpt-3.5-turbo">GPT-3.5 Turbo - Ekonomik</option>
                                <?php else: ?>
                                <option disabled>OpenAI API Key Gerekli</option>
                                <?php endif; ?>
                            </optgroup>
                            
                            <optgroup label="🟣 Anthropic (Claude)">
                                <?php if ($has_claude): ?>
                                <option value="claude-sonnet-4-5-20250929" selected>Claude Sonnet 4.5 - En Akıllı (Önerilen)</option>
                                <option value="claude-3-5-sonnet-20241022">Claude 3.5 Sonnet - Dengeli</option>
                                <option value="claude-3-opus-20240229">Claude 3 Opus - Maksimum Kalite</option>
                                <option value="claude-3-sonnet-20240229">Claude 3 Sonnet - Hızlı</option>
                                <option value="claude-3-haiku-20240307">Claude 3 Haiku - Çok Hızlı</option>
                                <?php else: ?>
                                <option disabled>Claude API Key Gerekli</option>
                                <?php endif; ?>
                            </optgroup>
                            
                            <optgroup label="🔴 Google (Gemini)">
                                <?php if ($has_gemini): ?>
                                <option value="gemini-2.0-flash-exp">Gemini 2.0 Flash - Deneysel (Ücretsiz)</option>
                                <option value="gemini-1.5-pro">Gemini 1.5 Pro - Gelişmiş</option>
                                <option value="gemini-1.5-flash">Gemini 1.5 Flash - Hızlı</option>
                                <option value="gemini-pro">Gemini Pro - Standart</option>
                                <?php else: ?>
                                <option disabled>Gemini API Key Gerekli</option>
                                <?php endif; ?>
                            </optgroup>
                            
                            <optgroup label="🟠 Jasper AI">
                                <?php if ($has_jasper): ?>
                                <option value="jasper-pro">Jasper Pro - Premium</option>
                                <option value="jasper-standard">Jasper Standard</option>
                                <?php else: ?>
                                <option disabled>Jasper API Key Gerekli</option>
                                <?php endif; ?>
                            </optgroup>
                        </select>
                        
                        <div class="model-comparison">
                            <table>
                                <tr>
                                    <th>Model</th>
                                    <th>Kalite</th>
                                    <th>Hız</th>
                                    <th>Maliyet</th>
                                    <th>En İyi Kullanım</th>
                                </tr>
                                <tr>
                                    <td><strong>GPT-4o</strong></td>
                                    <td>⭐⭐⭐⭐⭐</td>
                                    <td>⚡⚡⚡⚡</td>
                                    <td>💰💰💰</td>
                                    <td>Karmaşık içerik, analiz</td>
                                </tr>
                                <tr>
                                    <td><strong>Claude Sonnet 4.5</strong></td>
                                    <td>⭐⭐⭐⭐⭐</td>
                                    <td>⚡⚡⚡⚡⚡</td>
                                    <td>💰💰</td>
                                    <td>Uzun içerik, SEO, yaratıcılık</td>
                                </tr>
                                <tr>
                                    <td><strong>Gemini 2.0 Flash</strong></td>
                                    <td>⭐⭐⭐⭐</td>
                                    <td>⚡⚡⚡⚡⚡</td>
                                    <td>💰 (Ücretsiz)</td>
                                    <td>Hızlı içerik, deneme</td>
                                </tr>
                                <tr>
                                    <td><strong>Jasper Pro</strong></td>
                                    <td>⭐⭐⭐⭐</td>
                                    <td>⚡⚡⚡</td>
                                    <td>💰💰💰💰</td>
                                    <td>Marketing, copywriting</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                
                <div class="form-grid-2">
                    <div class="form-card">
                        <div class="card-header">
                            <h2>📏 Makale Uzunluğu</h2>
                        </div>
                        <div class="card-body">
                            <input 
                                type="number" 
                                name="word_count" 
                                value="2000" 
                                min="500" 
                                max="5000" 
                                step="100"
                                class="widefat input-large"
                            />
                            <div class="input-info">
                                <strong>📊 Kelime Sayısı:</strong> 500 - 5000 arası<br>
                                <strong>✅ SEO İçin Önerilen:</strong> 1500-2500 kelime
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-card">
                        <div class="card-header">
                            <h2>🌍 Dil Seçimi</h2>
                        </div>
                        <div class="card-body">
                            <select name="language" class="widefat select-modern">
                                <option value="tr" selected>🇹🇷 Türkçe</option>
                                <option value="en">🇬🇧 English</option>
                            </select>
                            <div class="input-info">
                                Makalenin hangi dilde oluşturulacağını seçin
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sağ Panel - Ek Ayarlar -->
            <div class="side-panel">
                <div class="form-card">
                    <div class="card-header">
                        <h2>🔗 Link Ayarları</h2>
                        <span class="badge badge-new">Yeni</span>
                    </div>
                    <div class="card-body">
                        <label class="checkbox-modern">
                            <input type="checkbox" name="add_internal_links" value="1" checked />
                            <span class="checkmark"></span>
                            <div>
                                <strong>Internal Linkler</strong>
                                <p>Site içi ilgili makalelere otomatik link</p>
                            </div>
                        </label>
                        
                        <label class="checkbox-modern">
                            <input type="checkbox" name="add_external_links" value="1" checked />
                            <span class="checkmark"></span>
                            <div>
                                <strong>External Linkler</strong>
                                <p>Yüksek otoriteli sitelere link (Wikipedia, Google, Ahrefs)</p>
                            </div>
                        </label>
                        
                        <div class="info-box">
                            <strong>📌 Link Stratejisi:</strong><br>
                            • Her makalede 3-5 internal link<br>
                            • 1-3 yüksek otoriteli external link<br>
                            • Doğal anchor text kullanımı<br>
                            • Nofollow external linkler
                        </div>
                    </div>
                </div>
                
                <div class="form-card">
                    <div class="card-header">
                        <h2>📊 SEO Ayarları</h2>
                        <span class="badge badge-new">Yeni</span>
                    </div>
                    <div class="card-body">
                        <label class="checkbox-modern">
                            <input type="checkbox" name="auto_seo" value="1" checked />
                            <span class="checkmark"></span>
                            <div>
                                <strong>Otomatik SEO Optimizasyonu</strong>
                                <p>Meta title, description, focus keyword</p>
                            </div>
                        </label>
                        
                        <div class="info-box">
                            <strong>✨ SEO Özellikleri:</strong><br>
                            • Otomatik meta title (55 karakter)<br>
                            • Otomatik meta description (130 karakter)<br>
                            • Başlık yapısı (H1-H3)<br>
                            • Schema markup (Article + FAQ)<br>
                            • Yoast SEO & Rank Math uyumlu
                        </div>
                    </div>
                </div>
                
                <div class="form-card">
                    <div class="card-header">
                        <h2>🖼️ Resim Ayarları</h2>
                    </div>
                    <div class="card-body">
                        <label class="checkbox-modern">
                            <input type="checkbox" name="use_images" value="1" checked />
                            <span class="checkmark"></span>
                            <div>
                                <strong>Otomatik Resim Ekle</strong>
                                <p>Öne çıkan resim otomatik indir</p>
                            </div>
                        </label>
                        
                        <select name="image_provider" class="widefat select-modern">
                            <option value="pexels">Pexels (Ücretsiz)</option>
                            <option value="unsplash">Unsplash (Ücretsiz)</option>
                            <option value="pixabay">Pixabay (Ücretsiz)</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-card">
                    <div class="card-header">
                        <h2>🗂️ Kategoriler</h2>
                    </div>
                    <div class="card-body">
                        <select name="categories[]" class="widefat" multiple size="6">
                            <?php
                            $categories = get_categories(['hide_empty' => false]);
                            foreach ($categories as $category) {
                                echo '<option value="' . $category->term_id . '">' . esc_html($category->name) . '</option>';
                            }
                            ?>
                        </select>
                        <div class="input-info">
                            Ctrl/Cmd tuşuna basılı tutarak birden fazla seçin
                        </div>
                    </div>
                </div>
                
                <div class="form-card">
                    <div class="card-header">
                        <h2>📅 Yayınlama</h2>
                    </div>
                    <div class="card-body">
                        <select name="publish_option" class="widefat select-modern">
                            <option value="draft">📝 Taslak olarak kaydet</option>
                            <option value="publish">✅ Hemen yayınla</option>
                            <option value="future">⏱️ Zamanla (Günlük otomatik)</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Üretim Butonu -->
        <div class="form-actions">
            <button type="submit" class="button button-primary button-hero generate-btn" id="generate-button-v6">
                <span class="btn-icon">🚀</span>
                <span class="btn-text">Makaleleri Oluştur</span>
            </button>
            <div class="action-info">
                <p>
                    ⏱️ Her makale yaklaşık <strong>30-90 saniye</strong> sürer (modele göre değişir)<br>
                    💡 Sayfadan ayrılmayın, işlem tamamlanana kadar bekleyin
                </p>
            </div>
        </div>
    </form>
</div>

<style>
/* Modern v6.0 Stilleri */
.mimoza-content-generator-v6 {
    max-width: 1400px;
    margin: 20px auto;
}

.mimoza-hero-box {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 40px;
    border-radius: 15px;
    margin: 20px 0 30px;
    text-align: center;
    box-shadow: 0 10px 40px rgba(102, 126, 234, 0.3);
}

.mimoza-hero-box h2 {
    margin: 0 0 15px 0;
    font-size: 28px;
    font-weight: 600;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-top: 30px;
}

.feature {
    background: rgba(255, 255, 255, 0.1);
    padding: 20px;
    border-radius: 10px;
    backdrop-filter: blur(10px);
}

.feature .icon {
    font-size: 36px;
    display: block;
    margin-bottom: 10px;
}

.feature strong {
    display: block;
    font-size: 16px;
    margin-bottom: 5px;
}

.feature p {
    margin: 0;
    font-size: 13px;
    opacity: 0.9;
}

.form-layout {
    display: grid;
    grid-template-columns: 1fr 400px;
    gap: 30px;
    margin: 30px 0;
}

.form-card {
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    margin-bottom: 20px;
    overflow: hidden;
    border: 1px solid #e0e0e0;
    transition: all 0.3s ease;
}

.form-card:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.card-header {
    background: linear-gradient(135deg, #f5f7fa 0%, #e8ebf0 100%);
    padding: 20px;
    border-bottom: 2px solid #e0e0e0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-header h2 {
    margin: 0;
    font-size: 16px;
    font-weight: 600;
    color: #2c3e50;
}

.card-body {
    padding: 25px;
}

.badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
}

.badge-optional {
    background: #95a5a6;
    color: white;
}

.badge-new {
    background: #e74c3c;
    color: white;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.7; }
}

.code-style {
    font-family: 'Courier New', monospace;
    font-size: 13px;
    line-height: 1.6;
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 15px;
}

.select-modern {
    height: 45px;
    font-size: 14px;
    border-radius: 6px;
    border: 1px solid #dee2e6;
}

.input-large {
    height: 45px;
    font-size: 16px;
    text-align: center;
    font-weight: 600;
}

.input-info {
    margin-top: 12px;
    font-size: 13px;
    color: #666;
    line-height: 1.6;
}

.input-info strong {
    color: #333;
}

.input-info code {
    background: #f0f0f0;
    padding: 2px 6px;
    border-radius: 3px;
    font-family: monospace;
}

.checkbox-modern {
    display: flex;
    align-items: flex-start;
    padding: 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.checkbox-modern:hover {
    border-color: #667eea;
    background: #f8f9ff;
}

.checkbox-modern input[type="checkbox"] {
    position: absolute;
    opacity: 0;
}

.checkbox-modern .checkmark {
    width: 22px;
    height: 22px;
    border: 2px solid #ccc;
    border-radius: 4px;
    margin-right: 12px;
    flex-shrink: 0;
    position: relative;
    background: white;
    transition: all 0.3s ease;
}

.checkbox-modern input[type="checkbox"]:checked + .checkmark {
    background: #667eea;
    border-color: #667eea;
}

.checkbox-modern input[type="checkbox"]:checked + .checkmark:after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
    font-size: 14px;
}

.checkbox-modern strong {
    display: block;
    font-size: 14px;
    color: #2c3e50;
    margin-bottom: 4px;
}

.checkbox-modern p {
    margin: 0;
    font-size: 12px;
    color: #7f8c8d;
}

.info-box {
    background: #e3f2fd;
    border-left: 4px solid #2196f3;
    padding: 15px;
    border-radius: 6px;
    margin-top: 15px;
    font-size: 13px;
    line-height: 1.8;
}

.model-comparison {
    margin-top: 20px;
    overflow-x: auto;
}

.model-comparison table {
    width: 100%;
    border-collapse: collapse;
    font-size: 12px;
}

.model-comparison th,
.model-comparison td {
    padding: 10px;
    text-align: left;
    border-bottom: 1px solid #e0e0e0;
}

.model-comparison th {
    background: #f5f7fa;
    font-weight: 600;
    color: #2c3e50;
}

.form-grid-2 {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
}

.form-actions {
    text-align: center;
    padding: 40px 0;
    background: linear-gradient(135deg, #f5f7fa 0%, #e8ebf0 100%);
    border-radius: 12px;
    margin-top: 30px;
}

.generate-btn {
    padding: 18px 50px !important;
    font-size: 18px !important;
    height: auto !important;
    border-radius: 50px !important;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none !important;
    color: white !important;
    font-weight: 600 !important;
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4) !important;
    transition: all 0.3s ease !important;
    display: inline-flex;
    align-items: center;
    gap: 10px;
}

.generate-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 35px rgba(102, 126, 234, 0.5) !important;
}

.generate-btn .btn-icon {
    font-size: 24px;
}

.action-info {
    margin-top: 20px;
}

.action-info p {
    margin: 5px 0;
    font-size: 14px;
    color: #666;
}

@media (max-width: 1200px) {
    .form-layout {
        grid-template-columns: 1fr;
    }
    
    .form-grid-2 {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    $('#mimoza-content-form-v6').on('submit', function(e) {
        var keywords = $('textarea[name="keywords"]').val().trim();
        
        if (!keywords) {
            alert('⚠️ Lütfen en az bir anahtar kelime girin!');
            e.preventDefault();
            return false;
        }
        
        var keywordCount = keywords.split('\n').filter(k => k.trim()).length;
        var selectedModel = $('select[name="ai_model"]').val();
        var estimatedTime = Math.ceil(keywordCount * 1); // dakika
        
        if (!confirm('🚀 İÇERİK ÜRETİMİ BAŞLAYACAK\n\n' +
                     '📝 Makale Sayısı: ' + keywordCount + '\n' +
                     '🤖 AI Model: ' + selectedModel + '\n' +
                     '⏱️ Tahmini Süre: ' + estimatedTime + ' dakika\n\n' +
                     'Devam etmek istiyor musunuz?')) {
            e.preventDefault();
            return false;
        }
        
        var $button = $('#generate-button-v6');
        var $btnText = $button.find('.btn-text');
        var $btnIcon = $button.find('.btn-icon');
        
        $button.prop('disabled', true);
        $btnIcon.text('⏳');
        $btnText.text('Makaleler Oluşturuluyor... (' + keywordCount + ' adet)');
        
        // Progress göstergesi
        var dots = 0;
        var progressInterval = setInterval(function() {
            dots = (dots + 1) % 4;
            var dotString = '.'.repeat(dots);
            $btnText.text('Makaleler Oluşturuluyor' + dotString + ' (' + keywordCount + ' adet)');
        }, 500);
    });
});
</script>
