<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap mimoza-dashboard">
    <h1>
        🚀 Mimoza AI SEO
        <span class="badge free-badge">TAMAMEN ÜCRETSİZ</span>
    </h1>
    
    <!-- İstatistik Kartları -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">📝</div>
            <div class="stat-content">
                <div class="stat-label">Bugün</div>
                <div class="stat-value"><?php echo $stats['today']; ?></div>
                <div class="stat-change">Makale üretildi</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">📅</div>
            <div class="stat-content">
                <div class="stat-label">Bu Hafta</div>
                <div class="stat-value"><?php echo $stats['week']; ?></div>
                <div class="stat-change">Makale üretildi</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">📊</div>
            <div class="stat-content">
                <div class="stat-label">Bu Ay</div>
                <div class="stat-value"><?php echo $stats['month']; ?></div>
                <div class="stat-change">Makale üretildi</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">🎯</div>
            <div class="stat-content">
                <div class="stat-label">Toplam</div>
                <div class="stat-value"><?php echo $stats['total']; ?></div>
                <div class="stat-change">Tüm zamanlar</div>
            </div>
        </div>
    </div>
    
    <!-- Özellikler Banner -->
    <div class="features-banner">
        <h2>✨ Tüm Özellikler Ücretsiz!</h2>
        <div class="features-list">
            <div class="feature-item">✅ Sınırsız makale üretimi</div>
            <div class="feature-item">✅ Tüm AI modelleri (GPT, Claude, Gemini)</div>
            <div class="feature-item">✅ Otomatik resim ekleme</div>
            <div class="feature-item">✅ SEO optimizasyonu</div>
            <div class="feature-item">✅ Link havuzu yönetimi</div>
            <div class="feature-item">✅ Zamanlama özellikleri</div>
            <div class="feature-item">✅ 5000 kelimeye kadar makaleler</div>
            <div class="feature-item">✅ Hiçbir ücret yok!</div>
        </div>
    </div>
    
    <!-- Hızlı Başlangıç -->
    <div class="quick-start-section">
        <h2>🚀 Hızlı Başlangıç</h2>
        
        <div class="quick-actions">
            <a href="<?php echo admin_url('admin.php?page=mimoza-content-generator'); ?>" class="quick-action-card">
                <div class="qa-icon">✏️</div>
                <h3>Yeni Makale Üret</h3>
                <p>AI ile SEO uyumlu içerik oluştur</p>
            </a>
            
            <a href="<?php echo admin_url('admin.php?page=mimoza-settings'); ?>" class="quick-action-card">
                <div class="qa-icon">⚙️</div>
                <h3>API Ayarları</h3>
                <p>AI ve resim servislerini yapılandır</p>
            </a>
            
            <a href="<?php echo admin_url('admin.php?page=mimoza-link-pool'); ?>" class="quick-action-card">
                <div class="qa-icon">🔗</div>
                <h3>Link Havuzu</h3>
                <p>İç ve dış linkleri yönet</p>
            </a>
            
            <a href="<?php echo admin_url('admin.php?page=mimoza-scheduling'); ?>" class="quick-action-card">
                <div class="qa-icon">⏰</div>
                <h3>Zamanlama</h3>
                <p>Otomatik yayınlama ayarla</p>
            </a>
        </div>
    </div>
    
    <!-- Son Üretilen Makaleler -->
    <?php
    global $wpdb;
    $recent = $wpdb->get_results(
        "SELECT g.*, p.post_title, p.post_status 
         FROM {$wpdb->prefix}mimoza_generations g
         LEFT JOIN {$wpdb->posts} p ON g.post_id = p.ID
         ORDER BY g.created_at DESC
         LIMIT 10"
    );
    ?>
    
    <?php if (!empty($recent)): ?>
    <div class="recent-posts-section">
        <h2>📄 Son Üretilen Makaleler</h2>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>Başlık</th>
                    <th>Anahtar Kelime</th>
                    <th>Model</th>
                    <th>Kelime</th>
                    <th>Durum</th>
                    <th>Tarih</th>
                    <th>İşlem</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recent as $item): ?>
                <tr>
                    <td>
                        <strong>
                            <a href="<?php echo get_edit_post_link($item->post_id); ?>">
                                <?php echo esc_html($item->post_title); ?>
                            </a>
                        </strong>
                    </td>
                    <td><?php echo esc_html($item->keyword); ?></td>
                    <td>
                        <code><?php echo esc_html($item->model); ?></code>
                    </td>
                    <td><?php echo number_format($item->word_count); ?></td>
                    <td>
                        <?php
                        $status_labels = [
                            'publish' => '<span class="status-badge published">✓ Yayında</span>',
                            'draft' => '<span class="status-badge draft">📝 Taslak</span>',
                            'future' => '<span class="status-badge scheduled">⏰ Zamanlanmış</span>'
                        ];
                        echo $status_labels[$item->post_status] ?? $item->post_status;
                        ?>
                    </td>
                    <td><?php echo date('d.m.Y H:i', strtotime($item->created_at)); ?></td>
                    <td>
                        <a href="<?php echo get_edit_post_link($item->post_id); ?>" class="button button-small">
                            Düzenle
                        </a>
                        <a href="<?php echo get_permalink($item->post_id); ?>" class="button button-small" target="_blank">
                            Görüntüle
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
    
    <!-- Sistem Durumu -->
    <div class="system-status-section">
        <h2>🔧 Sistem Durumu</h2>
        
        <div class="status-grid">
            <div class="status-item">
                <div class="status-label">OpenAI API</div>
                <div class="status-value">
                    <?php echo get_option('mimoza_openai_api_key') ? '<span class="status-ok">✓ Yapılandırıldı</span>' : '<span class="status-error">✗ Eksik</span>'; ?>
                </div>
            </div>
            
            <div class="status-item">
                <div class="status-label">Claude API</div>
                <div class="status-value">
                    <?php echo get_option('mimoza_claude_api_key') ? '<span class="status-ok">✓ Yapılandırıldı</span>' : '<span class="status-error">✗ Eksik</span>'; ?>
                </div>
            </div>
            
            <div class="status-item">
                <div class="status-label">Gemini API</div>
                <div class="status-value">
                    <?php echo get_option('mimoza_gemini_api_key') ? '<span class="status-ok">✓ Yapılandırıldı</span>' : '<span class="status-error">✗ Eksik</span>'; ?>
                </div>
            </div>
            
            <div class="status-item">
                <div class="status-label">Resim API'leri</div>
                <div class="status-value">
                    <?php 
                    $image_apis = [
                        get_option('mimoza_pexels_api_key'),
                        get_option('mimoza_unsplash_api_key'),
                        get_option('mimoza_pixabay_api_key')
                    ];
                    $configured = count(array_filter($image_apis));
                    echo $configured > 0 ? '<span class="status-ok">✓ ' . $configured . ' API</span>' : '<span class="status-error">✗ Eksik</span>';
                    ?>
                </div>
            </div>
            
            <div class="status-item">
                <div class="status-label">SEO Eklentisi</div>
                <div class="status-value">
                    <?php 
                    if (defined('WPSEO_VERSION')) {
                        echo '<span class="status-ok">✓ Yoast SEO</span>';
                    } elseif (class_exists('RankMath')) {
                        echo '<span class="status-ok">✓ Rank Math</span>';
                    } else {
                        echo '<span class="status-warning">⚠ Önerilir</span>';
                    }
                    ?>
                </div>
            </div>
            
            <div class="status-item">
                <div class="status-label">WordPress</div>
                <div class="status-value">
                    <span class="status-ok">✓ <?php echo get_bloginfo('version'); ?></span>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.mimoza-dashboard {
    max-width: 1400px;
}

.badge {
    display: inline-block;
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: bold;
    margin-left: 15px;
}

.free-badge {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 20px;
    margin: 30px 0;
}

.stat-card {
    background: white;
    padding: 25px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    display: flex;
    gap: 20px;
    align-items: center;
    transition: transform 0.3s;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.stat-icon {
    font-size: 48px;
}

.stat-label {
    font-size: 14px;
    color: #666;
    margin-bottom: 5px;
}

.stat-value {
    font-size: 36px;
    font-weight: bold;
    color: #333;
}

.stat-change {
    font-size: 12px;
    color: #999;
}

.features-banner {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 30px;
    border-radius: 15px;
    margin: 30px 0;
    text-align: center;
}

.features-banner h2 {
    margin: 0 0 20px 0;
    font-size: 28px;
}

.features-list {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 15px;
    margin-top: 20px;
}

.feature-item {
    background: rgba(255,255,255,0.1);
    padding: 15px;
    border-radius: 8px;
    font-weight: 600;
}

.quick-start-section {
    margin: 40px 0;
}

.quick-actions {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.quick-action-card {
    background: white;
    padding: 30px;
    border-radius: 10px;
    text-align: center;
    text-decoration: none;
    color: inherit;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    transition: all 0.3s;
    border: 2px solid transparent;
}

.quick-action-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
    border-color: #667eea;
}

.qa-icon {
    font-size: 48px;
    margin-bottom: 15px;
}

.quick-action-card h3 {
    margin: 10px 0;
    font-size: 18px;
}

.quick-action-card p {
    margin: 0;
    font-size: 14px;
    color: #666;
}

.recent-posts-section,
.system-status-section {
    background: white;
    padding: 30px;
    border-radius: 10px;
    margin: 30px 0;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.status-badge {
    display: inline-block;
    padding: 5px 12px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.status-badge.published {
    background: #d4edda;
    color: #155724;
}

.status-badge.draft {
    background: #fff3cd;
    color: #856404;
}

.status-badge.scheduled {
    background: #d1ecf1;
    color: #0c5460;
}

.status-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin-top: 20px;
}

.status-item {
    padding: 20px;
    background: #f9f9f9;
    border-radius: 8px;
}

.status-label {
    font-weight: 600;
    margin-bottom: 10px;
}

.status-ok {
    color: #46b450;
    font-weight: 600;
}

.status-error {
    color: #dc3232;
    font-weight: 600;
}

.status-warning {
    color: #ffb900;
    font-weight: 600;
}

@media (max-width: 1200px) {
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .features-list {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .status-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .stats-grid,
    .features-list,
    .status-grid {
        grid-template-columns: 1fr;
    }
}
</style>