<?php
if (!defined('ABSPATH')) exit;

// Zamanlanmış yazıları getir
global $wpdb;
$scheduled_posts = $wpdb->get_results("
    SELECT p.*, pm.meta_value as scheduled_time
    FROM {$wpdb->posts} p
    INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
    WHERE p.post_status = 'future'
    AND pm.meta_key = '_mimoza_scheduled'
    ORDER BY p.post_date ASC
");
?>

<div class="wrap mimoza-scheduling">
    <h1>⏰ Zamanlama Yönetimi</h1>
    
    <div class="scheduling-info">
        <p class="description">
            Makaleleri gelecekte belirli tarihlerde otomatik olarak yayınlayın. 
            İçerik Üretici sayfasından "Zamanla" seçeneği ile yeni zamanlamalar oluşturabilirsiniz.
        </p>
    </div>
    
    <!-- İstatistikler -->
    <div class="schedule-stats">
        <div class="stat-box">
            <div class="stat-icon">📅</div>
            <div class="stat-content">
                <h3><?php echo count($scheduled_posts); ?></h3>
                <p>Zamanlanmış Makale</p>
            </div>
        </div>
        
        <div class="stat-box">
            <div class="stat-icon">🕐</div>
            <div class="stat-content">
                <?php
                $next_post = !empty($scheduled_posts) ? $scheduled_posts[0] : null;
                ?>
                <h3><?php echo $next_post ? date('d.m.Y H:i', strtotime($next_post->post_date)) : '-'; ?></h3>
                <p>Bir Sonraki Yayın</p>
            </div>
        </div>
        
        <div class="stat-box">
            <div class="stat-icon">📊</div>
            <div class="stat-content">
                <?php
                $today = date('Y-m-d');
                $today_count = count(array_filter($scheduled_posts, function($p) use ($today) {
                    return date('Y-m-d', strtotime($p->post_date)) === $today;
                }));
                ?>
                <h3><?php echo $today_count; ?></h3>
                <p>Bugün Yayınlanacak</p>
            </div>
        </div>
    </div>
    
    <!-- Zamanlanmış Yazılar Listesi -->
    <?php if (empty($scheduled_posts)): ?>
        <div class="no-scheduled-posts">
            <div class="empty-icon">🔭</div>
            <h2>Henüz zamanlanmış yazı yok</h2>
            <p>İçerik Üretici sayfasından "Zamanla" seçeneği ile makale oluşturun.</p>
            <a href="<?php echo admin_url('admin.php?page=mimoza-content-generator'); ?>" class="button button-primary button-hero">
                Yeni Makale Oluştur
            </a>
        </div>
    <?php else: ?>
        <div class="scheduled-posts-list">
            <h2>Zamanlanmış Makaleler</h2>
            
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th width="5%">#</th>
                        <th width="35%">Başlık</th>
                        <th width="15%">Yayın Tarihi</th>
                        <th width="10%">Yayın Saati</th>
                        <th width="15%">Kategori</th>
                        <th width="10%">Durum</th>
                        <th width="10%">İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($scheduled_posts as $index => $post): 
                        $categories = get_the_category($post->ID);
                        $cat_names = array_map(function($cat) { return $cat->name; }, $categories);
                    ?>
                    <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <strong>
                                <a href="<?php echo get_edit_post_link($post->ID); ?>">
                                    <?php echo esc_html($post->post_title); ?>
                                </a>
                            </strong>
                        </td>
                        <td><?php echo date('d.m.Y', strtotime($post->post_date)); ?></td>
                        <td><?php echo date('H:i', strtotime($post->post_date)); ?></td>
                        <td><?php echo implode(', ', $cat_names) ?: '-'; ?></td>
                        <td>
                            <?php
                            $now = current_time('timestamp');
                            $scheduled_time = strtotime($post->post_date);
                            
                            if ($scheduled_time <= $now) {
                                echo '<span class="status-badge publishing">🔄 Yayınlanıyor</span>';
                            } else {
                                $diff = $scheduled_time - $now;
                                $hours = floor($diff / 3600);
                                
                                if ($hours < 1) {
                                    echo '<span class="status-badge soon">⏱️ Çok Yakında</span>';
                                } elseif ($hours < 24) {
                                    echo '<span class="status-badge today">📅 Bugün</span>';
                                } else {
                                    echo '<span class="status-badge scheduled">⏰ Zamanlandı</span>';
                                }
                            }
                            ?>
                        </td>
                        <td>
                            <button class="button button-small publish-now" data-post-id="<?php echo $post->ID; ?>">
                                Hemen Yayınla
                            </button>
                            <button class="button button-small button-link-delete cancel-schedule" data-post-id="<?php echo $post->ID; ?>">
                                İptal
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <!-- Toplu İşlemler -->
            <div class="bulk-actions-section">
                <h3>Toplu İşlemler</h3>
                <button class="button publish-all-now">Tümünü Hemen Yayınla</button>
                <button class="button button-link-delete cancel-all-schedules">Tüm Zamanlamaları İptal Et</button>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Zamanlama İpuçları -->
    <div class="scheduling-tips">
        <h2>💡 Zamanlama İpuçları</h2>
        
        <div class="tips-grid">
            <div class="tip-card">
                <h4>📅 En İyi Yayın Saatleri</h4>
                <p>Genelde 09:00, 14:00 ve 20:00 saatleri daha fazla trafik alır.</p>
            </div>
            
            <div class="tip-card">
                <h4>🔄 Düzenli Yayın</h4>
                <p>Günde 2-3 makale düzenli yayınlamak SEO için idealdir.</p>
            </div>
            
            <div class="tip-card">
                <h4>📊 İçerik Çeşitliliği</h4>
                <p>Farklı kategorilerde makale yayınlayarak okuyucu kitlenizi genişletin.</p>
            </div>
            
            <div class="tip-card">
                <h4>⏰ Hafta Sonu</h4>
                <p>Hafta sonu trafiği düşük olabilir, hafta içine odaklanın.</p>
            </div>
        </div>
    </div>
</div>

<style>
.mimoza-scheduling {
    max-width: 1400px;
}

.scheduling-info {
    background: #e7f3ff;
    padding: 20px;
    border-radius: 10px;
    border-left: 4px solid #2196F3;
    margin: 20px 0;
}

.schedule-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin: 30px 0;
}

.stat-box {
    background: white;
    padding: 25px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    display: flex;
    gap: 20px;
    align-items: center;
}

.stat-icon {
    font-size: 48px;
}

.stat-content h3 {
    margin: 0;
    font-size: 32px;
    color: #333;
}

.stat-content p {
    margin: 5px 0 0 0;
    color: #666;
    font-size: 14px;
}

.no-scheduled-posts {
    background: white;
    padding: 60px;
    border-radius: 10px;
    text-align: center;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.empty-icon {
    font-size: 80px;
    margin-bottom: 20px;
}

.no-scheduled-posts h2 {
    margin: 20px 0 10px;
    color: #666;
}

.scheduled-posts-list {
    background: white;
    padding: 30px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    margin: 30px 0;
}

.status-badge {
    display: inline-block;
    padding: 5px 12px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.status-badge.publishing {
    background: #2196F3;
    color: white;
}

.status-badge.soon {
    background: #ff9800;
    color: white;
}

.status-badge.today {
    background: #4caf50;
    color: white;
}

.status-badge.scheduled {
    background: #9e9e9e;
    color: white;
}

.bulk-actions-section {
    margin-top: 30px;
    padding-top: 20px;
    border-top: 1px solid #ddd;
}

.bulk-actions-section button {
    margin-right: 10px;
}

.scheduling-tips {
    background: white;
    padding: 30px;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    margin: 30px 0;
}

.tips-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
    margin-top: 20px;
}

.tip-card {
    background: #f9f9f9;
    padding: 20px;
    border-radius: 10px;
    border-left: 4px solid #667eea;
}

.tip-card h4 {
    margin-top: 0;
    color: #667eea;
}

@media (max-width: 768px) {
    .schedule-stats,
    .tips-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    // Hemen yayınla
    $('.publish-now').on('click', function() {
        if (!confirm('Bu makaleyi hemen yayınlamak istediğinize emin misiniz?')) {
            return;
        }
        
        const postId = $(this).data('post-id');
        
        $.post(ajaxurl, {
            action: 'mimoza_publish_now',
            post_id: postId,
            nonce: '<?php echo wp_create_nonce('mimoza_nonce'); ?>'
        }, function(response) {
            if (response.success) {
                alert('Makale yayınlandı!');
                location.reload();
            } else {
                alert('Hata: ' + response.data);
            }
        });
    });
    
    // Zamanlamayı iptal et
    $('.cancel-schedule').on('click', function() {
        if (!confirm('Zamanlamayı iptal etmek istediğinize emin misiniz? Makale taslak olarak kaydedilecek.')) {
            return;
        }
        
        const postId = $(this).data('post-id');
        
        $.post(ajaxurl, {
            action: 'mimoza_cancel_schedule',
            post_id: postId,
            nonce: '<?php echo wp_create_nonce('mimoza_nonce'); ?>'
        }, function(response) {
            if (response.success) {
                alert('Zamanlama iptal edildi!');
                location.reload();
            } else {
                alert('Hata: ' + response.data);
            }
        });
    });
    
    // Tümünü hemen yayınla
    $('.publish-all-now').on('click', function() {
        if (!confirm('Tüm zamanlanmış makaleleri hemen yayınlamak istediğinize emin misiniz?')) {
            return;
        }
        
        $(this).prop('disabled', true).text('⏳ Yayınlanıyor...');
        
        $.post(ajaxurl, {
            action: 'mimoza_publish_all_scheduled',
            nonce: '<?php echo wp_create_nonce('mimoza_nonce'); ?>'
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                location.reload();
            } else {
                alert('Hata: ' + response.data);
            }
        });
    });
    
    // Tüm zamanlamaları iptal et
    $('.cancel-all-schedules').on('click', function() {
        if (!confirm('Tüm zamanlamaları iptal etmek istediğinize emin misiniz? Makaleler taslak olarak kaydedilecek.')) {
            return;
        }
        
        $(this).prop('disabled', true).text('⏳ İptal ediliyor...');
        
        $.post(ajaxurl, {
            action: 'mimoza_cancel_all_schedules',
            nonce: '<?php echo wp_create_nonce('mimoza_nonce'); ?>'
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                location.reload();
            } else {
                alert('Hata: ' + response.data);
            }
        });
    });
});
</script>