<?php
if (!defined('ABSPATH')) exit;

// Ayarları kaydet
if (isset($_POST['mimoza_save_settings'])) {
    check_admin_referer('mimoza_settings_nonce');
    
    // AI API Keys
    update_option('mimoza_openai_api_key', sanitize_text_field($_POST['openai_api_key']));
    update_option('mimoza_claude_api_key', sanitize_text_field($_POST['claude_api_key']));
    update_option('mimoza_gemini_api_key', sanitize_text_field($_POST['gemini_api_key']));
    update_option('mimoza_jasper_api_key', sanitize_text_field($_POST['jasper_api_key']));
    
    // Image API Keys
    update_option('mimoza_pexels_api_key', sanitize_text_field($_POST['pexels_api_key']));
    update_option('mimoza_unsplash_api_key', sanitize_text_field($_POST['unsplash_api_key']));
    update_option('mimoza_pixabay_api_key', sanitize_text_field($_POST['pixabay_api_key']));
    
    // Advanced Settings
    update_option('mimoza_default_model', sanitize_text_field($_POST['default_model']));
    update_option('mimoza_default_word_count', intval($_POST['default_word_count']));
    update_option('mimoza_auto_internal_links', sanitize_text_field($_POST['auto_internal_links']));
    update_option('mimoza_auto_external_links', sanitize_text_field($_POST['auto_external_links']));
    
    echo '<div class="notice notice-success is-dismissible"><p><strong>✓ Başarılı!</strong> Ayarlar kaydedildi.</p></div>';
}

// Mevcut ayarları al
$openai_key = get_option('mimoza_openai_api_key', '');
$claude_key = get_option('mimoza_claude_api_key', '');
$gemini_key = get_option('mimoza_gemini_api_key', '');
$jasper_key = get_option('mimoza_jasper_api_key', '');

$pexels_key = get_option('mimoza_pexels_api_key', '');
$unsplash_key = get_option('mimoza_unsplash_api_key', '');
$pixabay_key = get_option('mimoza_pixabay_api_key', '');

$default_model = get_option('mimoza_default_model', 'claude-sonnet-4-5-20250929');
$default_word_count = get_option('mimoza_default_word_count', 2000);
$auto_internal = get_option('mimoza_auto_internal_links', 'yes');
$auto_external = get_option('mimoza_auto_external_links', 'yes');
?>

<div class="wrap mimoza-settings-v6">
    <h1>⚙️ Mimoza AI SEO Premium v6.0 - Ayarlar</h1>
    
    <div class="settings-hero">
        <h2>🔑 API Anahtarlarınızı ve Tercihlerinizi Yönetin</h2>
        <p>Modern AI motorlarıyla güçlü içerik üretimi için API anahtarlarınızı ekleyin</p>
    </div>
    
    <form method="post" action="" class="mimoza-settings-form">
        <?php wp_nonce_field('mimoza_settings_nonce'); ?>
        <input type="hidden" name="mimoza_save_settings" value="1" />
        
        <div class="settings-tabs">
            <button type="button" class="tab-button active" data-tab="ai-keys">🤖 AI API Anahtarları</button>
            <button type="button" class="tab-button" data-tab="image-keys">🖼️ Resim API Anahtarları</button>
            <button type="button" class="tab-button" data-tab="advanced">⚙️ Gelişmiş Ayarlar</button>
        </div>
        
        <!-- AI API Keys Tab -->
        <div class="tab-content active" id="ai-keys">
            <div class="settings-section">
                <div class="section-header">
                    <h2>🔵 OpenAI (ChatGPT)</h2>
                    <span class="status-badge <?php echo !empty($openai_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($openai_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="openai_api_key" 
                            value="<?php echo esc_attr($openai_key); ?>" 
                            class="widefat api-key-input"
                            placeholder="sk-proj-..."
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 API Anahtarı Nasıl Alınır:</strong><br>
                        1. <a href="https://platform.openai.com/api-keys" target="_blank">platform.openai.com/api-keys</a> adresine gidin<br>
                        2. "Create new secret key" butonuna tıklayın<br>
                        3. Oluşan anahtarı kopyalayın ve buraya yapıştırın<br>
                        <strong>💰 Fiyatlandırma:</strong> GPT-4o: $5/1M tokens | GPT-4 Turbo: $10/1M tokens
                    </div>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>🟣 Anthropic Claude</h2>
                    <span class="status-badge <?php echo !empty($claude_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($claude_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="claude_api_key" 
                            value="<?php echo esc_attr($claude_key); ?>" 
                            class="widefat api-key-input"
                            placeholder="sk-ant-api..."
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 API Anahtarı Nasıl Alınır:</strong><br>
                        1. <a href="https://console.anthropic.com/" target="_blank">console.anthropic.com</a> adresine gidin<br>
                        2. "Get API Keys" sekmesine tıklayın<br>
                        3. "Create Key" butonuna basın<br>
                        <strong>💰 Fiyatlandırma:</strong> Claude Sonnet 4.5: $3/1M tokens (Önerilen)<br>
                        <strong>⭐ En İyi Seçim:</strong> SEO içerik için Claude Sonnet 4.5 önerilir
                    </div>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>🔴 Google Gemini</h2>
                    <span class="status-badge <?php echo !empty($gemini_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($gemini_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="gemini_api_key" 
                            value="<?php echo esc_attr($gemini_key); ?>" 
                            class="widefat api-key-input"
                            placeholder="AIzaSy..."
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 API Anahtarı Nasıl Alınır:</strong><br>
                        1. <a href="https://makersuite.google.com/app/apikey" target="_blank">makersuite.google.com/app/apikey</a> adresine gidin<br>
                        2. "Create API Key" butonuna tıklayın<br>
                        3. Oluşan anahtarı kopyalayın<br>
                        <strong>💰 Fiyatlandırma:</strong> Gemini 2.0 Flash: Ücretsiz kotası var!<br>
                        <strong>🎁 Avantaj:</strong> Deneme için ideal, ücretsiz kullanım limiti
                    </div>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>🟠 Jasper AI</h2>
                    <span class="status-badge <?php echo !empty($jasper_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($jasper_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="jasper_api_key" 
                            value="<?php echo esc_attr($jasper_key); ?>" 
                            class="widefat api-key-input"
                            placeholder="jp_..."
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 API Anahtarı Nasıl Alınır:</strong><br>
                        1. <a href="https://app.jasper.ai/" target="_blank">app.jasper.ai</a> adresine gidin<br>
                        2. Settings > API sekmesine tıklayın<br>
                        3. "Generate API Key" butonuna basın<br>
                        <strong>💰 Fiyatlandırma:</strong> Abonelik gerektiriyor (Creator Plan $39/ay+)<br>
                        <strong>🎯 Kullanım:</strong> Marketing ve copywriting odaklı içerik için
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Image API Keys Tab -->
        <div class="tab-content" id="image-keys">
            <div class="settings-section">
                <div class="section-header">
                    <h2>📷 Pexels</h2>
                    <span class="status-badge <?php echo !empty($pexels_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($pexels_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="pexels_api_key" 
                            value="<?php echo esc_attr($pexels_key); ?>" 
                            class="widefat api-key-input"
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 Nasıl Alınır:</strong> <a href="https://www.pexels.com/api/" target="_blank">pexels.com/api</a> - Ücretsiz
                    </div>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>📸 Unsplash</h2>
                    <span class="status-badge <?php echo !empty($unsplash_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($unsplash_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="unsplash_api_key" 
                            value="<?php echo esc_attr($unsplash_key); ?>" 
                            class="widefat api-key-input"
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 Nasıl Alınır:</strong> <a href="https://unsplash.com/developers" target="_blank">unsplash.com/developers</a> - Ücretsiz
                    </div>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>🖼️ Pixabay</h2>
                    <span class="status-badge <?php echo !empty($pixabay_key) ? 'active' : 'inactive'; ?>">
                        <?php echo !empty($pixabay_key) ? '✓ Aktif' : '✗ Pasif'; ?>
                    </span>
                </div>
                <div class="section-body">
                    <div class="api-key-group">
                        <label>API Anahtarı:</label>
                        <input 
                            type="password" 
                            name="pixabay_api_key" 
                            value="<?php echo esc_attr($pixabay_key); ?>" 
                            class="widefat api-key-input"
                        />
                        <button type="button" class="toggle-visibility">👁️ Göster</button>
                    </div>
                    <div class="help-text">
                        <strong>📚 Nasıl Alınır:</strong> <a href="https://pixabay.com/api/docs/" target="_blank">pixabay.com/api/docs</a> - Ücretsiz
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Advanced Settings Tab -->
        <div class="tab-content" id="advanced">
            <div class="settings-section">
                <div class="section-header">
                    <h2>🤖 Varsayılan AI Modeli</h2>
                </div>
                <div class="section-body">
                    <select name="default_model" class="widefat select-large">
                        <option value="claude-sonnet-4-5-20250929" <?php selected($default_model, 'claude-sonnet-4-5-20250929'); ?>>
                            Claude Sonnet 4.5 (Önerilen)
                        </option>
                        <option value="gpt-4o" <?php selected($default_model, 'gpt-4o'); ?>>
                            GPT-4o
                        </option>
                        <option value="gemini-2.0-flash-exp" <?php selected($default_model, 'gemini-2.0-flash-exp'); ?>>
                            Gemini 2.0 Flash
                        </option>
                    </select>
                    <p class="help-text">İçerik üretirken varsayılan olarak kullanılacak AI modeli</p>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>📏 Varsayılan Makale Uzunluğu</h2>
                </div>
                <div class="section-body">
                    <input 
                        type="number" 
                        name="default_word_count" 
                        value="<?php echo esc_attr($default_word_count); ?>" 
                        min="500" 
                        max="5000" 
                        step="100"
                        class="widefat input-large"
                    />
                    <p class="help-text">Kelime sayısı (500-5000 arası, önerilen: 2000)</p>
                </div>
            </div>
            
            <div class="settings-section">
                <div class="section-header">
                    <h2>🔗 Otomatik Linking Ayarları</h2>
                </div>
                <div class="section-body">
                    <label class="checkbox-setting">
                        <input 
                            type="checkbox" 
                            name="auto_internal_links" 
                            value="yes" 
                            <?php checked($auto_internal, 'yes'); ?>
                        />
                        <strong>Internal Linkler Otomatik Eklensin</strong>
                        <p>Her makalede site içi ilgili makalelere otomatik link ekler (3-5 adet)</p>
                    </label>
                    
                    <label class="checkbox-setting">
                        <input 
                            type="checkbox" 
                            name="auto_external_links" 
                            value="yes" 
                            <?php checked($auto_external, 'yes'); ?>
                        />
                        <strong>External Linkler Otomatik Eklensin</strong>
                        <p>Yüksek otoriteli sitelere (Wikipedia, Google, Ahrefs) otomatik link ekler (1-3 adet)</p>
                    </label>
                </div>
            </div>
            
            <div class="settings-section info-section">
                <div class="section-header">
                    <h2>ℹ️ Sistem Bilgileri</h2>
                </div>
                <div class="section-body">
                    <table class="system-info">
                        <tr>
                            <td><strong>Plugin Versiyonu:</strong></td>
                            <td>6.0 Premium</td>
                        </tr>
                        <tr>
                            <td><strong>WordPress Versiyonu:</strong></td>
                            <td><?php echo get_bloginfo('version'); ?></td>
                        </tr>
                        <tr>
                            <td><strong>PHP Versiyonu:</strong></td>
                            <td><?php echo PHP_VERSION; ?></td>
                        </tr>
                        <tr>
                            <td><strong>Aktif AI Motorları:</strong></td>
                            <td>
                                <?php
                                $active_engines = [];
                                if (!empty($openai_key)) $active_engines[] = 'OpenAI';
                                if (!empty($claude_key)) $active_engines[] = 'Claude';
                                if (!empty($gemini_key)) $active_engines[] = 'Gemini';
                                if (!empty($jasper_key)) $active_engines[] = 'Jasper';
                                
                                echo !empty($active_engines) ? implode(', ', $active_engines) : 'Hiçbiri';
                                ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="button button-primary button-hero">
                💾 Ayarları Kaydet
            </button>
        </div>
    </form>
</div>

<style>
.mimoza-settings-v6 {
    max-width: 1200px;
    margin: 20px auto;
}

.settings-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 40px;
    border-radius: 15px;
    margin: 20px 0 30px;
    text-align: center;
}

.settings-hero h2 {
    margin: 0 0 10px 0;
    font-size: 28px;
}

.settings-tabs {
    display: flex;
    gap: 10px;
    margin-bottom: 30px;
    border-bottom: 2px solid #e0e0e0;
}

.tab-button {
    padding: 15px 30px;
    background: white;
    border: none;
    border-bottom: 3px solid transparent;
    cursor: pointer;
    font-size: 15px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.tab-button:hover {
    background: #f5f7fa;
}

.tab-button.active {
    border-bottom-color: #667eea;
    color: #667eea;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

.settings-section {
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    margin-bottom: 25px;
    overflow: hidden;
    border: 1px solid #e0e0e0;
}

.section-header {
    background: linear-gradient(135deg, #f5f7fa 0%, #e8ebf0 100%);
    padding: 20px 25px;
    border-bottom: 2px solid #e0e0e0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.section-header h2 {
    margin: 0;
    font-size: 18px;
    font-weight: 600;
}

.status-badge {
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.status-badge.active {
    background: #4caf50;
    color: white;
}

.status-badge.inactive {
    background: #f44336;
    color: white;
}

.section-body {
    padding: 30px 25px;
}

.api-key-group {
    position: relative;
    margin-bottom: 20px;
}

.api-key-group label {
    display: block;
    font-weight: 600;
    margin-bottom: 8px;
    color: #2c3e50;
}

.api-key-input {
    font-family: 'Courier New', monospace;
    font-size: 14px;
    padding: 12px;
    border-radius: 6px;
    border: 2px solid #dee2e6;
}

.api-key-input:focus {
    border-color: #667eea;
    outline: none;
}

.toggle-visibility {
    position: absolute;
    right: 10px;
    top: 38px;
    background: #f0f0f0;
    border: none;
    padding: 8px 15px;
    border-radius: 6px;
    cursor: pointer;
    font-size: 12px;
}

.toggle-visibility:hover {
    background: #e0e0e0;
}

.help-text {
    background: #f8f9fa;
    padding: 15px;
    border-left: 4px solid #667eea;
    border-radius: 6px;
    font-size: 13px;
    line-height: 1.8;
}

.help-text strong {
    color: #2c3e50;
}

.help-text a {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
}

.help-text a:hover {
    text-decoration: underline;
}

.checkbox-setting {
    display: block;
    padding: 20px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 15px;
    cursor: pointer;
}

.checkbox-setting:hover {
    border-color: #667eea;
    background: #f8f9ff;
}

.checkbox-setting input[type="checkbox"] {
    margin-right: 10px;
    width: 20px;
    height: 20px;
}

.checkbox-setting strong {
    display: block;
    font-size: 15px;
    margin-bottom: 5px;
}

.checkbox-setting p {
    margin: 0;
    font-size: 13px;
    color: #666;
    margin-left: 30px;
}

.select-large,
.input-large {
    height: 50px;
    font-size: 15px;
    border-radius: 6px;
}

.info-section {
    background: #e3f2fd;
    border-color: #2196f3;
}

.system-info {
    width: 100%;
}

.system-info tr {
    border-bottom: 1px solid #dee2e6;
}

.system-info td {
    padding: 12px 0;
}

.form-actions {
    text-align: center;
    padding: 40px 0;
}

.form-actions .button-hero {
    padding: 18px 50px !important;
    font-size: 18px !important;
    height: auto !important;
    border-radius: 50px !important;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none !important;
    color: white !important;
    font-weight: 600 !important;
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4) !important;
}

.form-actions .button-hero:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 35px rgba(102, 126, 234, 0.5) !important;
}
</style>

<script>
jQuery(document).ready(function($) {
    // Tab switching
    $('.tab-button').on('click', function() {
        var target = $(this).data('tab');
        
        $('.tab-button').removeClass('active');
        $(this).addClass('active');
        
        $('.tab-content').removeClass('active');
        $('#' + target).addClass('active');
    });
    
    // Toggle password visibility
    $('.toggle-visibility').on('click', function() {
        var $input = $(this).prev('.api-key-input');
        var type = $input.attr('type');
        
        if (type === 'password') {
            $input.attr('type', 'text');
            $(this).text('🔒 Gizle');
        } else {
            $input.attr('type', 'password');
            $(this).text('👁️ Göster');
        }
    });
});
</script>
