<?php
/**
 * Mimoza Lisans Satış Mağazası
 * Freemium model için özel satış sayfası
 */

if (!defined('ABSPATH')) exit;

class Mimoza_License_Shop {
    
    public function __construct() {
        // Shortcode
        add_shortcode('mimoza_license_shop', [$this, 'render_shop']);
        
        // AJAX
        add_action('wp_ajax_mimoza_add_to_cart', [$this, 'ajax_add_to_cart']);
        add_action('wp_ajax_nopriv_mimoza_add_to_cart', [$this, 'ajax_add_to_cart']);
        
        // Widget
        add_action('widgets_init', [$this, 'register_widget']);
        
        // Admin sayfası
        add_action('admin_menu', [$this, 'add_shop_page'], 100);
    }
    
    /**
     * Satış sayfası render
     * Kullanım: [mimoza_license_shop]
     */
    public function render_shop($atts) {
        $atts = shortcode_atts([
            'style' => 'cards', // cards, table, minimal
            'show_free' => 'yes'
        ], $atts);
        
        ob_start();
        ?>
        <div class="mimoza-license-shop" data-style="<?php echo esc_attr($atts['style']); ?>">
            <div class="shop-header">
                <h1>🚀 Mimoza AI SEO Premium</h1>
                <p class="subtitle">Yapay zeka ile otomatik içerik üretimi - SEO uyumlu makaleler</p>
            </div>
            
            <?php if ($atts['show_free'] === 'yes'): ?>
            <div class="free-trial-banner">
                <div class="banner-icon">🎁</div>
                <div class="banner-content">
                    <h3>Ücretsiz Başlayın!</h3>
                    <p>Kayıt olun, <strong>10 makale ücretsiz</strong> üretin. Kredi kartı gerekmez!</p>
                    <a href="<?php echo wp_registration_url(); ?>" class="btn btn-white">Hemen Başla →</a>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="packages-grid">
                <?php echo $this->render_package('basic'); ?>
                <?php echo $this->render_package('professional'); ?>
                <?php echo $this->render_package('enterprise'); ?>
            </div>
            
            <div class="features-comparison">
                <h2>✨ Özellik Karşılaştırması</h2>
                <?php echo $this->render_comparison_table(); ?>
            </div>
            
            <div class="testimonials">
                <h2>💬 Kullanıcı Yorumları</h2>
                <div class="testimonials-grid">
                    <?php echo $this->render_testimonials(); ?>
                </div>
            </div>
            
            <div class="faq-section">
                <h2>❓ Sıkça Sorulan Sorular</h2>
                <?php echo $this->render_faq(); ?>
            </div>
        </div>
        
        <style>
        .mimoza-license-shop {
            max-width: 1400px;
            margin: 40px auto;
            padding: 0 20px;
        }
        
        .shop-header {
            text-align: center;
            margin-bottom: 50px;
        }
        
        .shop-header h1 {
            font-size: 48px;
            margin-bottom: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .subtitle {
            font-size: 20px;
            color: #666;
        }
        
        .free-trial-banner {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            border-radius: 20px;
            display: flex;
            align-items: center;
            gap: 30px;
            margin-bottom: 60px;
            box-shadow: 0 10px 40px rgba(102, 126, 234, 0.3);
        }
        
        .banner-icon {
            font-size: 80px;
        }
        
        .banner-content h3 {
            margin: 0 0 10px 0;
            font-size: 32px;
        }
        
        .banner-content p {
            margin: 0 0 20px 0;
            font-size: 18px;
            opacity: 0.9;
        }
        
        .btn {
            display: inline-block;
            padding: 15px 40px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-white {
            background: white;
            color: #667eea;
        }
        
        .btn-white:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .packages-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
            margin-bottom: 80px;
        }
        
        .package-card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 5px 30px rgba(0,0,0,0.1);
            transition: all 0.3s;
            position: relative;
        }
        
        .package-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 50px rgba(0,0,0,0.15);
        }
        
        .package-card.popular {
            border: 3px solid #667eea;
            transform: scale(1.05);
        }
        
        .popular-badge {
            position: absolute;
            top: -15px;
            right: 20px;
            background: #667eea;
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 14px;
        }
        
        .package-name {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 15px;
        }
        
        .package-price {
            font-size: 48px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .package-price .currency {
            font-size: 24px;
            vertical-align: super;
        }
        
        .package-price .period {
            font-size: 18px;
            color: #999;
        }
        
        .package-features {
            list-style: none;
            padding: 0;
            margin: 30px 0;
        }
        
        .package-features li {
            padding: 12px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .package-features li:before {
            content: "✓ ";
            color: #4caf50;
            font-weight: bold;
            margin-right: 10px;
        }
        
        .btn-buy {
            width: 100%;
            padding: 18px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-buy:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }
        
        .features-comparison,
        .testimonials,
        .faq-section {
            margin-bottom: 80px;
        }
        
        .features-comparison h2,
        .testimonials h2,
        .faq-section h2 {
            text-align: center;
            font-size: 36px;
            margin-bottom: 40px;
        }
        
        @media (max-width: 1024px) {
            .packages-grid {
                grid-template-columns: 1fr;
            }
            
            .package-card.popular {
                transform: scale(1);
            }
        }
        </style>
        
        <script>
        jQuery(document).ready(function($) {
            $('.btn-buy').on('click', function() {
                var packageType = $(this).data('package');
                var $btn = $(this);
                
                $btn.prop('disabled', true).text('🔄 Yükleniyor...');
                
                $.post('<?php echo admin_url('admin-ajax.php'); ?>', {
                    action: 'mimoza_add_to_cart',
                    package: packageType,
                    nonce: '<?php echo wp_create_nonce('mimoza_shop'); ?>'
                }, function(response) {
                    if (response.success) {
                        window.location.href = response.data.checkout_url;
                    } else {
                        alert('Hata: ' + response.data);
                        $btn.prop('disabled', false).text('Satın Al');
                    }
                });
            });
        });
        </script>
        <?php
        
        return ob_get_clean();
    }
    
    /**
     * Paket kartı render
     */
    private function render_package($type) {
        $packages = [
            'basic' => [
                'name' => 'Basic',
                'price' => 199,
                'features' => [
                    '50 makale/ay',
                    'Tüm AI modelleri',
                    '3 resim/makale',
                    'Zamanlama özelliği',
                    'Link havuzu',
                    'SEO optimizasyonu'
                ],
                'popular' => false
            ],
            'professional' => [
                'name' => 'Professional',
                'price' => 299,
                'features' => [
                    '100 makale/ay',
                    'Tüm AI modelleri',
                    '5 resim/makale',
                    'Gelişmiş zamanlama',
                    'Link havuzu',
                    'SEO optimizasyonu',
                    'Öncelikli destek'
                ],
                'popular' => true
            ],
            'enterprise' => [
                'name' => 'Enterprise',
                'price' => 599,
                'features' => [
                    'Sınırsız makale',
                    'Tüm AI modelleri',
                    '10 resim/makale',
                    'Gelişmiş zamanlama',
                    'Link havuzu',
                    'SEO optimizasyonu',
                    'Öncelikli destek',
                    'Özel eğitim'
                ],
                'popular' => false
            ]
        ];
        
        $package = $packages[$type];
        
        ob_start();
        ?>
        <div class="package-card <?php echo $package['popular'] ? 'popular' : ''; ?>">
            <?php if ($package['popular']): ?>
                <div class="popular-badge">🔥 EN POPÜLER</div>
            <?php endif; ?>
            
            <div class="package-name"><?php echo $package['name']; ?></div>
            
            <div class="package-price">
                <span class="currency">₺</span><?php echo $package['price']; ?>
                <span class="period">/ay</span>
            </div>
            
            <ul class="package-features">
                <?php foreach ($package['features'] as $feature): ?>
                    <li><?php echo $feature; ?></li>
                <?php endforeach; ?>
            </ul>
            
            <button class="btn-buy" data-package="<?php echo $type; ?>">
                💳 Satın Al
            </button>
        </div>
        <?php
        
        return ob_get_clean();
    }
    
    /**
     * Karşılaştırma tablosu
     */
    private function render_comparison_table() {
        ob_start();
        ?>
        <table class="comparison-table">
            <thead>
                <tr>
                    <th>Özellik</th>
                    <th>Ücretsiz</th>
                    <th>Basic</th>
                    <th>Professional</th>
                    <th>Enterprise</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><strong>Aylık Makale</strong></td>
                    <td>10 (toplam)</td>
                    <td>50</td>
                    <td>100</td>
                    <td>Sınırsız</td>
                </tr>
                <tr>
                    <td><strong>AI Modelleri</strong></td>
                    <td>Temel</td>
                    <td>Tümü</td>
                    <td>Tümü</td>
                    <td>Tümü</td>
                </tr>
                <tr>
                    <td><strong>Resim/Makale</strong></td>
                    <td>1</td>
                    <td>3</td>
                    <td>5</td>
                    <td>10</td>
                </tr>
                <tr>
                    <td><strong>Zamanlama</strong></td>
                    <td>❌</td>
                    <td>✅</td>
                    <td>✅ Gelişmiş</td>
                    <td>✅ Gelişmiş</td>
                </tr>
                <tr>
                    <td><strong>Link Havuzu</strong></td>
                    <td>❌</td>
                    <td>✅</td>
                    <td>✅</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><strong>Destek</strong></td>
                    <td>Email</td>
                    <td>Email</td>
                    <td>Öncelikli</td>
                    <td>VIP</td>
                </tr>
                <tr>
                    <td><strong>Eğitim</strong></td>
                    <td>❌</td>
                    <td>❌</td>
                    <td>❌</td>
                    <td>✅ Özel</td>
                </tr>
            </tbody>
        </table>
        
        <style>
        .comparison-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .comparison-table th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            text-align: center;
            font-weight: 600;
        }
        
        .comparison-table td {
            padding: 15px 20px;
            border-bottom: 1px solid #f0f0f0;
            text-align: center;
        }
        
        .comparison-table td:first-child {
            text-align: left;
            font-weight: 500;
        }
        
        .comparison-table tr:hover {
            background: #f9f9f9;
        }
        </style>
        <?php
        
        return ob_get_clean();
    }
    
    /**
     * Yorumlar
     */
    private function render_testimonials() {
        $testimonials = [
            [
                'name' => 'Mehmet Yılmaz',
                'role' => 'Blog Sahibi',
                'text' => 'Günde 10 makale yazıyordum, şimdi 50 makale üretiyorum. Harika!',
                'rating' => 5
            ],
            [
                'name' => 'Ayşe Demir',
                'role' => 'SEO Uzmanı',
                'text' => 'Müşterilerim için içerik üretimi artık çok kolay. Zaman tasarrufu muazzam.',
                'rating' => 5
            ],
            [
                'name' => 'Can Özkan',
                'role' => 'E-ticaret',
                'text' => 'Ürün açıklamaları ve blog yazıları için mükemmel. Satışlarım %40 arttı.',
                'rating' => 5
            ]
        ];
        
        ob_start();
        
        foreach ($testimonials as $testimonial) {
            ?>
            <div class="testimonial-card">
                <div class="stars">
                    <?php echo str_repeat('⭐', $testimonial['rating']); ?>
                </div>
                <p class="testimonial-text">"<?php echo esc_html($testimonial['text']); ?>"</p>
                <div class="testimonial-author">
                    <strong><?php echo esc_html($testimonial['name']); ?></strong>
                    <span><?php echo esc_html($testimonial['role']); ?></span>
                </div>
            </div>
            <?php
        }
        
        ?>
        <style>
        .testimonials-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
        }
        
        .testimonial-card {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .stars {
            font-size: 24px;
            margin-bottom: 15px;
        }
        
        .testimonial-text {
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 20px;
            font-style: italic;
        }
        
        .testimonial-author strong {
            display: block;
            margin-bottom: 5px;
        }
        
        .testimonial-author span {
            color: #999;
            font-size: 14px;
        }
        
        @media (max-width: 1024px) {
            .testimonials-grid {
                grid-template-columns: 1fr;
            }
        }
        </style>
        <?php
        
        return ob_get_clean();
    }
    
    /**
     * SSS
     */
    private function render_faq() {
        $faqs = [
            [
                'q' => 'Ücretsiz sürümde neler var?',
                'a' => 'Ücretsiz sürümde toplam 10 makale üretebilirsiniz. Temel AI modelleri ve 1 resim/makale dahildir.'
            ],
            [
                'q' => 'Ödeme güvenli mi?',
                'a' => 'Evet, tüm ödemeler PayTR güvencesi altında işlenir. Kredi kartı bilgileriniz saklanmaz.'
            ],
            [
                'q' => 'İptal edebilir miyim?',
                'a' => 'İlk 14 gün içinde koşulsuz iade hakkınız vardır. İstediğiniz zaman iptal edebilirsiniz.'
            ],
            [
                'q' => 'Teknik destek var mı?',
                'a' => 'Evet, tüm kullanıcılar email desteği alır. Premium kullanıcılar öncelikli destek alır.'
            ]
        ];
        
        ob_start();
        ?>
        <div class="faq-list">
            <?php foreach ($faqs as $index => $faq): ?>
            <div class="faq-item">
                <div class="faq-question" data-index="<?php echo $index; ?>">
                    <span class="faq-icon">❓</span>
                    <strong><?php echo esc_html($faq['q']); ?></strong>
                    <span class="faq-toggle">▼</span>
                </div>
                <div class="faq-answer" id="faq-<?php echo $index; ?>">
                    <?php echo esc_html($faq['a']); ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <style>
        .faq-list {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .faq-item {
            background: white;
            border-radius: 10px;
            margin-bottom: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .faq-question {
            padding: 20px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: background 0.3s;
        }
        
        .faq-question:hover {
            background: #f9f9f9;
        }
        
        .faq-icon {
            font-size: 24px;
        }
        
        .faq-toggle {
            margin-left: auto;
            transition: transform 0.3s;
        }
        
        .faq-question.active .faq-toggle {
            transform: rotate(180deg);
        }
        
        .faq-answer {
            display: none;
            padding: 0 20px 20px 60px;
            color: #666;
            line-height: 1.6;
        }
        </style>
        
        <script>
        jQuery(document).ready(function($) {
            $('.faq-question').on('click', function() {
                var index = $(this).data('index');
                var $answer = $('#faq-' + index);
                
                $(this).toggleClass('active');
                $answer.slideToggle(300);
            });
        });
        </script>
        <?php
        
        return ob_get_clean();
    }
    
    /**
     * Sepete ekle AJAX
     */
    public function ajax_add_to_cart() {
        check_ajax_referer('mimoza_shop', 'nonce');
        
        $package = sanitize_text_field($_POST['package']);
        
        // WooCommerce ürününü bul
        $products = get_posts([
            'post_type' => 'product',
            'meta_key' => '_mimoza_license_type',
            'meta_value' => $package,
            'posts_per_page' => 1
        ]);
        
        if (empty($products)) {
            wp_send_json_error('Ürün bulunamadı');
        }
        
        $product_id = $products[0]->ID;
        
        // Sepeti temizle (tek ürün)
        WC()->cart->empty_cart();
        
        // Sepete ekle
        WC()->cart->add_to_cart($product_id);
        
        wp_send_json_success([
            'checkout_url' => wc_get_checkout_url()
        ]);
    }
    
    /**
     * Widget kaydı
     */
    public function register_widget() {
        register_widget('Mimoza_Upgrade_Widget');
    }
    
    /**
     * Admin sayfası
     */
    public function add_shop_page() {
        add_submenu_page(
            'mimoza-ai-seo',
            'Lisans Satış',
            '💰 Lisans Satış',
            'manage_options',
            'mimoza-license-shop',
            [$this, 'render_admin_page']
        );
    }
    
    public function render_admin_page() {
        ?>
        <div class="wrap">
            <h1>💰 Lisans Satış Yönetimi</h1>
            
            <div class="mimoza-shop-admin">
                <div class="admin-section">
                    <h2>📊 Satış İstatistikleri</h2>
                    <?php echo $this->get_sales_stats(); ?>
                </div>
                
                <div class="admin-section">
                    <h2>🛍️ Satış Sayfası</h2>
                    <p>Aşağıdaki kodu bir sayfaya ekleyerek satış sayfanızı oluşturun:</p>
                    <code>[mimoza_license_shop]</code>
                    
                    <p style="margin-top: 20px;">
                        <a href="<?php echo admin_url('post-new.php?post_type=page'); ?>" class="button button-primary">
                            Yeni Sayfa Oluştur
                        </a>
                    </p>
                </div>
                
                <div class="admin-section">
                    <h2>⚙️ PayTR Ayarları</h2>
                    <p>
                        <a href="<?php echo admin_url('admin.php?page=wc-settings&tab=checkout&section=mimoza_paytr'); ?>" class="button">
                            PayTR Ayarlarına Git →
                        </a>
                    </p>
                </div>
                
                <div class="admin-section">
                    <h2>🎯 Dönüşüm Optimizasyonu</h2>
                    <ul>
                        <li>✅ Ücretsiz deneme aktif (10 makale)</li>
                        <li>✅ 3 farklı paket seçeneği</li>
                        <li>✅ PayTR güvenli ödeme</li>
                        <li>✅ 14 gün iade garantisi</li>
                        <li>✅ Otomatik lisans aktivasyonu</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <style>
        .mimoza-shop-admin {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin-top: 30px;
        }
        
        .admin-section {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .admin-section h2 {
            margin-top: 0;
            border-bottom: 2px solid #f0f0f0;
            padding-bottom: 15px;
        }
        
        .admin-section code {
            display: block;
            background: #f4f4f4;
            padding: 15px;
            border-radius: 5px;
            font-size: 14px;
            margin: 15px 0;
        }
        
        .admin-section ul {
            list-style: none;
            padding: 0;
        }
        
        .admin-section li {
            padding: 10px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        </style>
        <?php
    }
    
    private function get_sales_stats() {
        global $wpdb;
        
        // Bugünkü satışlar
        $today = $wpdb->get_var("
            SELECT COUNT(*) FROM {$wpdb->posts} 
            WHERE post_type = 'shop_order' 
            AND post_status = 'wc-completed'
            AND DATE(post_date) = CURDATE()
        ");
        
        // Bu ayki satışlar
        $this_month = $wpdb->get_var("
            SELECT COUNT(*) FROM {$wpdb->posts} 
            WHERE post_type = 'shop_order' 
            AND post_status = 'wc-completed'
            AND MONTH(post_date) = MONTH(NOW())
            AND YEAR(post_date) = YEAR(NOW())
        ");
        
        // Toplam gelir
        $total_revenue = $wpdb->get_var("
            SELECT SUM(meta_value) FROM {$wpdb->postmeta} 
            WHERE meta_key = '_order_total'
            AND post_id IN (
                SELECT ID FROM {$wpdb->posts} 
                WHERE post_type = 'shop_order' 
                AND post_status = 'wc-completed'
            )
        ");
        
        ob_start();
        ?>
        <div class="stats-grid">
            <div class="stat-box">
                <div class="stat-value"><?php echo $today; ?></div>
                <div class="stat-label">Bugün</div>
            </div>
            <div class="stat-box">
                <div class="stat-value"><?php echo $this_month; ?></div>
                <div class="stat-label">Bu Ay</div>
            </div>
            <div class="stat-box">
                <div class="stat-value">₺<?php echo number_format($total_revenue, 2); ?></div>
                <div class="stat-label">Toplam Gelir</div>
            </div>
        </div>
        
        <style>
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-top: 20px;
        }
        
        .stat-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            text-align: center;
        }
        
        .stat-value {
            font-size: 36px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .stat-label {
            font-size: 14px;
            opacity: 0.9;
        }
        </style>
        <?php
        
        return ob_get_clean();
    }
}

new Mimoza_License_Shop();