// ===== Mimoza İletişim Pro – Drawer + Callback (fix4 ClickOnly + WhatsApp) =====
(function(){
  var cfg = window.MimozaIletisim || {};
  function nowInfo(){
    var d = new Date(); var pad = function(n){ return String(n).padStart(2,'0'); };
    return {
      title: document.title || '',
      url: window.location.href,
      site: (window.location.hostname || ''),
      date: pad(d.getFullYear())+'-'+pad(d.getMonth()+1)+'-'+pad(d.getDate()),
      time: pad(d.getHours())+':'+pad(d.getMinutes())
    };
  }
  function tpl(s, ctx){ return (s||'').replace(/\{(title|url|site|date|time)\}/g, function(_,k){ return ctx[k] || ''; }); }
  function addUTM(u, utm){
    try{ var url = new URL(u, location.href);
      if (utm && utm.source) url.searchParams.set('utm_source', utm.source);
      if (utm && utm.medium) url.searchParams.set('utm_medium', utm.medium);
      if (utm && utm.campaign) url.searchParams.set('utm_campaign', utm.campaign);
      return url.toString();
    }catch(e){ return u; }
  }
  function withinHours(){
    var h = cfg.hours || {}; if (!h.enabled) return true;
    var d = new Date(); var days = ['sun','mon','tue','wed','thu','fri','sat']; var dayKey = days[d.getDay()];
    if (!h.days || h.days.indexOf(dayKey) === -1) return !h.hideOutside;
    var ss = (h.start||'09:00').split(':'), es = (h.end||'19:00').split(':');
    var start = (+ss[0])*60 + (+ss[1]); var end = (+es[0])*60 + (+es[1]);
    var cur = d.getHours()*60 + d.getMinutes();
    var inside = cur>=start && cur<=end; return inside || !h.hideOutside;
  }
  function track(name, params){
    if (typeof window.gtag==='function'){ window.gtag('event', name, params||{}); }
    else if (Array.isArray(window.dataLayer)){ window.dataLayer.push(Object.assign({event:name}, params||{})); }
    if (typeof window.fbq==='function'){ window.fbq('trackCustom', name, params||{}); }
  }
  function enhanceLinks(root){
    var info = nowInfo();
    root.querySelectorAll('a.contact-whatsapp').forEach(function(a){
      var num = a.getAttribute('data-wa'); if (!num) return;
      var url = 'https://wa.me/'+num;
      if (cfg.enablePrefill && cfg.prefillTemplate){ url += '?text='+encodeURIComponent(tpl(cfg.prefillTemplate, info)); }
      if (cfg.enableUTM){ url = addUTM(url, cfg.utm || {}); }
      a.setAttribute('href', url);
    });
    root.querySelectorAll('a.contact-messenger').forEach(function(a){
      var user = a.getAttribute('data-msgr'); if (!user) return;
      var url = 'https://m.me/'+user.replace(/^\//,'');
      if (cfg.enableUTM){
        var ref = encodeURIComponent(JSON.stringify({utm: cfg.utm, page: info.url, t: Date.now()}));
        url += '?ref='+ref;
      }
      a.setAttribute('href', url);
    });
    root.querySelectorAll('a.contact-button').forEach(function(a){
      a.addEventListener('click', function(){
        var cls = Array.from(a.classList).find(function(c){ return /contact-(\w+)/.test(c); });
        var type = cls ? cls.replace('contact-','') : 'unknown';
        track('mimoza_contact_click', {channel:type, page_title:info.title, page_location:info.url});
      }, {passive:true});
    });
  }
  function openDrawer(drawer, backdrop, fab){
    drawer.hidden = false; backdrop.hidden = false; fab.setAttribute('aria-expanded','true');
    track('mimoza_drawer_open', {page_location: location.href});
    setTimeout(function(){
      var first = drawer.querySelector('button, a, input, textarea, [tabindex]:not([tabindex="-1"])');
      if (first) first.focus();
    }, 0);
    document.documentElement.style.setProperty('overflow','hidden');
  }
  function closeDrawer(drawer, backdrop, fab){
    drawer.hidden = true; backdrop.hidden = true; fab.setAttribute('aria-expanded','false');
    document.documentElement.style.removeProperty('overflow');
  }
  function bindDrawer(){
    var fab = document.getElementById('mimoza-fab');
    var drawer = document.getElementById('mimoza-drawer');
    var backdrop = document.getElementById('mimoza-backdrop');
    var closeBtn = document.getElementById('mimoza-drawer-close');
    if (!fab || !drawer || !backdrop || !closeBtn) return;
    fab.addEventListener('click', function(){ openDrawer(drawer, backdrop, fab); });
    closeBtn.addEventListener('click', function(){ closeDrawer(drawer, backdrop, fab); });
    backdrop.addEventListener('click', function(){ closeDrawer(drawer, backdrop, fab); });
    document.addEventListener('keydown', function(e){
      if (e.key==='Escape' && !drawer.hidden) closeDrawer(drawer, backdrop, fab);
    });
    // Hover-to-open removed in fix4
  }

  function refreshNonce(){ 
    return fetch((cfg.ajax && cfg.ajax.rest) ? cfg.ajax.rest : '', {credentials:'same-origin'})
      .then(function(r){ return r.json(); })
      .then(function(j){ if (j && j.nonce){ cfg.ajax.nonce = j.nonce; return j.nonce; } throw new Error('no-nonce'); });
  }

  function bindCallbackForms(){
    var info = nowInfo();
    document.querySelectorAll('form.mimoza-callback').forEach(function(form){
      enhanceLinks(form);
      form.addEventListener('submit', function(e){
        e.preventDefault();
        var msg = form.querySelector('.cb-msg'); var btn = form.querySelector('.cb-submit');
        var fd = new FormData(form);
        if (!fd.get('agree')){ msg.textContent='Lütfen onayı işaretleyin.'; return; }
        btn.disabled = true; msg.textContent = (cfg.callback && cfg.callback.mode==='whatsapp') ? 'WhatsApp açılıyor...' : 'Gönderiliyor...';
        var name = (fd.get('name')||'').toString().trim();
        var phone = (fd.get('phone')||'').toString().trim();
        var note = (fd.get('note')||'').toString().trim();
        if (name.length < 2 || phone.length < 6){ msg.textContent='Ad ve telefon zorunludur.'; btn.disabled=false; return; }

        if (cfg.callback && cfg.callback.mode === 'whatsapp'){
          var wa = (cfg.callback.waRecipient || '').toString();
          if (!wa){ msg.textContent='WhatsApp numarası tanımlı değil.'; btn.disabled=false; return; }
          var body = 'Merhaba, beni arar mısınız?%0A'
                   + 'Ad Soyad: ' + encodeURIComponent(name) + '%0A'
                   + 'Telefon: ' + encodeURIComponent(phone) + (note ? '%0A'+'Not: '+encodeURIComponent(note) : '')
                   + '%0A%0ASayfa: ' + encodeURIComponent(info.title) + '%0AURL: ' + encodeURIComponent(info.url);
          var url = 'https://wa.me/'+ wa + '?text=' + body;
          if (cfg.enableUTM){ url = addUTM(url, cfg.utm || {}); }
          try{ window.open(url, '_blank', 'noopener'); }catch(_){ location.href = url; }
          track('mimoza_callback_submit', {status:'wa_redirect', page_location: info.url});
          btn.disabled=false;
          return;
        }

        // Email mode (AJAX with nonce refresh + retry)
        var fd2 = new FormData(form);
        fd2.append('action','mimoza_cb');
        fd2.append('nonce', (cfg.ajax && cfg.ajax.nonce) ? cfg.ajax.nonce : '');
        fd2.append('page', info.url);
        fd2.append('title', info.title);
        var triedRefresh = false;
        function submitOnce(){
          return fetch((cfg.ajax && cfg.ajax.url) ? cfg.ajax.url : '', { method:'POST', body: fd2, credentials:'same-origin' })
            .then(function(res){ return res.json().catch(function(){ return {success:false, data:{msg:'Sunucu hatası'}}; }); })
            .then(function(data){
              if (data && data.success){
                msg.textContent = (cfg.callback && cfg.callback.success) ? cfg.callback.success : 'Talebiniz alındı.';
                form.reset();
                track('mimoza_callback_submit', {status:'success', page_location: info.url});
              }else{
                var text = (data && data.data && data.data.msg) ? data.data.msg : 'Gönderim başarısız.';
                var errStr = JSON.stringify(data||{}).toLowerCase();
                if (!triedRefresh && (errStr.includes('nonce') || errStr.includes('cheatin') || errStr.includes('-1')) ){
                  triedRefresh = true;
                  return refreshNonce().then(function(n){
                    fd2.set('nonce', n);
                    return submitOnce();
                  }).catch(function(){
                    msg.textContent = text;
                    track('mimoza_callback_submit', {status:'nonce_error', page_location: info.url});
                  });
                }
                msg.textContent = text;
                track('mimoza_callback_submit', {status:'error', page_location: info.url});
              }
            }).catch(function(){
              msg.textContent = 'Bağlantı hatası.';
              track('mimoza_callback_submit', {status:'network_error', page_location: info.url});
            }).finally(function(){ btn.disabled = false; });
        }
        submitOnce();
      });
    });
  }

  function init(){
    var root = document.querySelector('.mimoza-contact'); if (!root) return;
    if (!withinHours()){ if (cfg.hours && cfg.hours.hideOutside){ root.style.display='none'; return; } }
    enhanceLinks(root);
    if (cfg.drawer){ bindDrawer(); }
    bindCallbackForms();
    if (cfg.brandColor){ root.style.setProperty('--mimoza-brand', cfg.brandColor); }
  }
  if (document.readyState === 'loading'){ document.addEventListener('DOMContentLoaded', init); } else { init(); }
})();
